/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class BinaryRunner {
    IProject project;
    Thread runner;

    public BinaryRunner(IProject iProject) {
        this.project = iProject;
    }

    public void start() {
        this.runner = new Thread(new Runnable(){

            public void run() {
                ICProject iCProject = CModelManager.getDefault().create(BinaryRunner.this.project);
                if (iCProject == null || Thread.currentThread().isInterrupted()) {
                    return;
                }
                BinaryContainer binaryContainer = (BinaryContainer)iCProject.getBinaryContainer();
                ArchiveContainer archiveContainer = (ArchiveContainer)iCProject.getArchiveContainer();
                archiveContainer.removeChildren();
                binaryContainer.removeChildren();
                try {
                    iCProject.getProject().accept((IResourceVisitor)new Visitor(BinaryRunner.this));
                }
                catch (CoreException coreException) {
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (!Thread.currentThread().isInterrupted()) {
                    BinaryRunner.this.fireEvents(iCProject, binaryContainer);
                    BinaryRunner.this.fireEvents(iCProject, archiveContainer);
                }
                BinaryRunner binaryRunner = BinaryRunner.this;
                synchronized (binaryRunner) {
                    BinaryRunner.this.notifyAll();
                    BinaryRunner.this.runner = null;
                }
            }
        }, CCorePlugin.getResourceString("CoreModel.BinaryRunner.Binary_Search_Thread"));
        this.runner.start();
    }

    public synchronized void waitIfRunning() {
        while (this.runner != null && this.runner.isAlive()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        if (this.runner != null && this.runner.isAlive()) {
            this.runner.interrupt();
        }
    }

    void fireEvents(ICProject iCProject, Parent parent) {
        ICElement[] iCElementArray = parent.getChildren();
        if (iCElementArray.length > 0) {
            CModelManager cModelManager = CModelManager.getDefault();
            ICModel iCModel = cModelManager.getCModel();
            CElementDelta cElementDelta = new CElementDelta(iCModel);
            cElementDelta.added(iCProject);
            cElementDelta.added(parent);
            int n = 0;
            while (n < iCElementArray.length) {
                cElementDelta.added(iCElementArray[n]);
                ++n;
            }
            cModelManager.registerCModelDelta(cElementDelta);
            cModelManager.fire(1);
        }
    }

    void addChildIfBinary(IFile iFile) {
        IBinaryParser.IBinaryFile iBinaryFile;
        CModelManager cModelManager = CModelManager.getDefault();
        if (!cModelManager.isTranslationUnit(iFile) && (iBinaryFile = cModelManager.createBinaryFile(iFile)) != null) {
            IContainer iContainer = iFile.getParent();
            ICElement iCElement = cModelManager.create((IResource)iContainer);
            cModelManager.create(iCElement, iFile, iBinaryFile);
        }
    }

    class Visitor
    implements IResourceVisitor {
        BinaryRunner runner;

        public Visitor(BinaryRunner binaryRunner2) {
            this.runner = binaryRunner2;
        }

        public boolean visit(IResource iResource) throws CoreException {
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            if (iResource instanceof IFile) {
                this.runner.addChildIfBinary((IFile)iResource);
                return false;
            }
            return true;
        }
    }
}

