/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.cdt.internal.core.model.CContainerInfo;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;

public class DeltaProcessor {
    protected CElementDelta fCurrentDelta;
    protected IndexManager indexManager = new IndexManager();
    ICElement currentElement;
    static final ICElementDelta[] NO_DELTA = new ICElementDelta[0];
    public static boolean VERBOSE = false;
    ICElement movedFromElement = null;

    protected ICElement createElement(IResource iResource) {
        ICElement iCElement;
        CModelManager cModelManager = CModelManager.getDefault();
        if (iResource == null) {
            return null;
        }
        ICElement iCElement2 = cModelManager.create(iResource);
        if (iCElement2 == null && (iCElement = cModelManager.create((IResource)iResource.getParent())) instanceof IParent) {
            ICProject iCProject;
            IResource iResource2;
            int n;
            ICProject iCProject2;
            ICElement iCElement3;
            ICElement[] iCElementArray;
            if (CModelManager.getDefault().peekAtInfo(iCElement) != null) {
                iCElementArray = ((CElement)iCElement).getElementInfo().getChildren();
                int n2 = 0;
                while (n2 < iCElementArray.length) {
                    iCElement3 = iCElementArray[n2].getResource();
                    if (iCElement3 != null && iCElement3.equals(iResource)) {
                        iCElement2 = iCElementArray[n2];
                        break;
                    }
                    ++n2;
                }
            }
            if (iCElement2 == null && (iCProject2 = iCElement.getCProject()) != null) {
                iCElement3 = iCProject2.getBinaryContainer();
                iCElementArray = ((CElement)iCElement3).getElementInfo().getChildren();
                n = 0;
                while (n < iCElementArray.length) {
                    iResource2 = iCElementArray[n].getResource();
                    if (iResource2 != null && iResource2.equals((Object)iResource)) {
                        iCElement2 = iCElementArray[n];
                        break;
                    }
                    ++n;
                }
            }
            if (iCElement2 == null && (iCProject = iCElement.getCProject()) != null) {
                iCElement3 = iCProject.getArchiveContainer();
                iCElementArray = ((CElement)iCElement3).getElementInfo().getChildren();
                n = 0;
                while (n < iCElementArray.length) {
                    iResource2 = iCElementArray[n].getResource();
                    if (iResource2 != null && iResource2.equals((Object)iResource)) {
                        iCElement2 = iCElementArray[n];
                        break;
                    }
                    ++n;
                }
            }
        }
        return iCElement2;
    }

    protected ICElement createElement(IPath iPath) {
        return CModelManager.getDefault().create(iPath);
    }

    protected void releaseCElement(ICElement iCElement) {
        CModelManager.getDefault().releaseCElement(iCElement);
    }

    protected void addToParentInfo(Openable openable) {
        Openable openable2 = (Openable)openable.getParent();
        if (openable2 != null && openable2.isOpen()) {
            CElementInfo cElementInfo = openable2.getElementInfo();
            cElementInfo.addChild(openable);
        }
    }

    protected void elementAdded(ICElement iCElement, IResourceDelta iResourceDelta) {
        if (iCElement instanceof Openable) {
            this.addToParentInfo((Openable)iCElement);
        }
        if ((iResourceDelta.getFlags() & 0x1000) != 0) {
            if (this.movedFromElement == null) {
                this.movedFromElement = this.createElement(iResourceDelta.getMovedFromPath());
            }
            this.fCurrentDelta.movedTo(iCElement, this.movedFromElement);
            this.movedFromElement = null;
        } else {
            this.fCurrentDelta.added(iCElement);
        }
    }

    protected void elementClosed(ICElement iCElement, IResourceDelta iResourceDelta) {
        if (iCElement.getElementType() == 11) {
            this.elementRemoved(iCElement, iResourceDelta);
        } else {
            this.fCurrentDelta.closed(iCElement);
        }
    }

    protected void elementOpened(ICElement iCElement, IResourceDelta iResourceDelta) {
        if (iCElement.getElementType() == 11) {
            if (this.hasCNature(iResourceDelta.getResource())) {
                this.elementAdded(iCElement, iResourceDelta);
            }
        } else {
            this.fCurrentDelta.opened(iCElement);
        }
    }

    private void close(Openable openable) {
        try {
            openable.close();
        }
        catch (CModelException cModelException) {}
    }

    protected void elementChanged(ICElement iCElement, IResourceDelta iResourceDelta) {
        if (iCElement instanceof Openable) {
            this.close((Openable)iCElement);
        }
        this.fCurrentDelta.changed(iCElement, 1);
    }

    protected void elementRemoved(ICElement iCElement, IResourceDelta iResourceDelta) {
        if ((iResourceDelta.getFlags() & 0x2000) != 0) {
            IPath iPath = iResourceDelta.getMovedToPath();
            ICElement iCElement2 = this.createElement(iPath);
            if (iCElement2 == null) {
                this.fCurrentDelta.removed(iCElement);
            } else {
                this.movedFromElement = iCElement;
                this.fCurrentDelta.movedFrom(iCElement, iCElement2);
            }
        } else {
            this.fCurrentDelta.removed(iCElement);
        }
        this.releaseCElement(iCElement);
    }

    protected ICElementDelta[] filterRealDeltas(ICElementDelta[] iCElementDeltaArray) {
        int n = iCElementDeltaArray.length;
        ICElementDelta[] iCElementDeltaArray2 = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            CElementDelta cElementDelta = (CElementDelta)iCElementDeltaArray[n3];
            if (cElementDelta != null && (cElementDelta.getAffectedChildren().length > 0 || cElementDelta.getKind() == 1 || cElementDelta.getKind() == 2 || (cElementDelta.getFlags() & 0x80) != 0 || (cElementDelta.getFlags() & 0x40) != 0 || cElementDelta.resourceDeltasCounter > 0)) {
                if (iCElementDeltaArray2 == null) {
                    iCElementDeltaArray2 = new ICElementDelta[n];
                }
                iCElementDeltaArray2[n2++] = cElementDelta;
            }
            ++n3;
        }
        if (n2 > 0) {
            ICElementDelta[] iCElementDeltaArray3 = new ICElementDelta[n2];
            System.arraycopy(iCElementDeltaArray2, 0, iCElementDeltaArray3, 0, n2);
            return iCElementDeltaArray3;
        }
        return NO_DELTA;
    }

    protected boolean hasCNature(IResource iResource) {
        IProject iProject = iResource.getProject();
        if (iProject.isOpen()) {
            return CoreModel.getDefault().hasCNature(iProject);
        }
        return false;
    }

    public ICElementDelta[] processResourceDelta(IResourceDelta iResourceDelta) {
        ICModel iCModel = CModelManager.getDefault().getCModel();
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        ICElementDelta[] iCElementDeltaArray = new CElementDelta[iResourceDeltaArray.length];
        int n = 0;
        while (n < iResourceDeltaArray.length) {
            IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
            this.fCurrentDelta = new CElementDelta(iCModel);
            this.traverseDelta(iCModel, iResourceDelta2);
            iCElementDeltaArray[n] = this.fCurrentDelta;
            ++n;
        }
        return this.filterRealDeltas(iCElementDeltaArray);
    }

    protected void traverseDelta(ICElement iResourceDeltaArray, IResourceDelta iResourceDelta) {
        IResourceDelta[] iResourceDeltaArray2;
        try {
            iResourceDeltaArray2 = this.updateCurrentDeltaAndIndex(iResourceDelta);
            if (iResourceDeltaArray2 == null) {
                this.nonCResourcesChanged((ICElement)iResourceDeltaArray, iResourceDelta);
            } else {
                iResourceDeltaArray = iResourceDeltaArray2;
            }
        }
        catch (CModelException cModelException) {}
        iResourceDeltaArray2 = iResourceDelta.getAffectedChildren();
        int n = 0;
        while (n < iResourceDeltaArray2.length) {
            this.traverseDelta((ICElement)iResourceDeltaArray, iResourceDeltaArray2[n]);
            ++n;
        }
    }

    protected void nonCResourcesChanged(ICElement iCElement, IResourceDelta iResourceDelta) {
        CElementInfo cElementInfo;
        CElementDelta cElementDelta = this.fCurrentDelta.find(iCElement);
        if (cElementDelta == null) {
            this.fCurrentDelta.changed(iCElement, 1);
            cElementDelta = this.fCurrentDelta.find(iCElement);
            if (cElementDelta != null) {
                cElementDelta.addResourceDelta(iResourceDelta);
            }
        } else {
            cElementDelta.addResourceDelta(iResourceDelta);
        }
        if (iCElement instanceof CContainer && CModelManager.getDefault().peekAtInfo(iCElement) != null && (cElementInfo = ((CContainer)iCElement).getElementInfo()) instanceof CContainerInfo) {
            ((CContainerInfo)cElementInfo).setNonCResources(null);
        }
    }

    private ICElement updateCurrentDeltaAndIndex(IResourceDelta iResourceDelta) throws CModelException {
        IResource iResource = iResourceDelta.getResource();
        ICElement iCElement = this.createElement(iResource);
        switch (iResourceDelta.getKind()) {
            case 1: {
                if (iCElement == null) break;
                this.updateIndexAddResource(iCElement, iResourceDelta);
                this.elementAdded(iCElement, iResourceDelta);
                break;
            }
            case 2: {
                if (iCElement == null) break;
                this.updateIndexRemoveResource(iCElement, iResourceDelta);
                this.elementRemoved(iCElement, iResourceDelta);
                break;
            }
            case 4: {
                int n = iResourceDelta.getFlags();
                if ((n & 0x100) != 0) {
                    if (iCElement == null) break;
                    this.elementChanged(iCElement, iResourceDelta);
                    this.updateIndexAddResource(iCElement, iResourceDelta);
                    this.updateDependencies(iCElement);
                    break;
                }
                if (iResource.getType() != 4) break;
                if ((n & 0x4000) != 0) {
                    IProject iProject = (IProject)iResource;
                    if (iCElement != null) {
                        if (iProject.isOpen()) {
                            this.elementOpened(iCElement, iResourceDelta);
                            this.updateIndexAddResource(iCElement, iResourceDelta);
                        } else {
                            this.elementClosed(iCElement, iResourceDelta);
                            this.updateIndexRemoveResource(iCElement, iResourceDelta);
                        }
                    }
                }
                if ((n & 0x80000) == 0 || iCElement == null) break;
                this.elementAdded(iCElement, iResourceDelta);
            }
        }
        return iCElement;
    }

    protected void updateIndexAddResource(ICElement iCElement, IResourceDelta iResourceDelta) {
        if (this.indexManager == null) {
            return;
        }
        switch (iCElement.getElementType()) {
            case 11: {
                this.indexManager.indexAll(iCElement.getCProject().getProject());
                break;
            }
            case 60: {
                IFile iFile = (IFile)iResourceDelta.getResource();
                IProject iProject = iFile.getProject();
                this.indexManager.addSource(iFile, iProject.getFullPath());
            }
        }
    }

    protected void updateIndexRemoveResource(ICElement iCElement, IResourceDelta iResourceDelta) {
        if (this.indexManager == null) {
            return;
        }
        switch (iCElement.getElementType()) {
            case 11: {
                this.indexManager.removeIndexFamily(iCElement.getCProject().getProject().getFullPath());
                break;
            }
            case 60: {
                IFile iFile = (IFile)iResourceDelta.getResource();
                this.indexManager.remove(iFile.getFullPath().toString(), iFile.getProject().getProject().getFullPath());
            }
        }
    }

    private void updateDependencies(ICElement iCElement) {
        IResource iResource = iCElement.getResource();
        if (iResource == null) {
            return;
        }
        String string = iResource.getFileExtension();
        if (string != null && this.isValidHeader(string)) {
            this.indexManager.updateDependencies(iResource);
        }
    }

    private boolean isValidHeader(String string) {
        String[] stringArray = CModelManager.headerExtensions;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

