/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelBuilder;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;
import org.eclipse.cdt.internal.core.model.TranslationUnitInfo;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class TranslationUnit
extends Openable
implements ITranslationUnit {
    IPath location = null;
    SourceManipulationInfo sourceManipulationInfo = null;

    public TranslationUnit(ICElement iCElement, IFile iFile) {
        super(iCElement, (IResource)iFile, 60);
    }

    public TranslationUnit(ICElement iCElement, IPath iPath) {
        super(iCElement, iPath, 60);
    }

    public ITranslationUnit getTranslationUnit() {
        return this;
    }

    public IInclude createInclude(String string, ICElement iCElement, IProgressMonitor iProgressMonitor) throws CModelException {
        return null;
    }

    public IUsing createUsing(String string, IProgressMonitor iProgressMonitor) throws CModelException {
        return null;
    }

    public ICElement getElementAtLine(int n) throws CModelException {
        ICElement[] iCElementArray = this.getChildren();
        int n2 = 0;
        while (n2 < iCElementArray.length) {
            ISourceRange iSourceRange = ((ISourceReference)((Object)iCElementArray[n2])).getSourceRange();
            int n3 = iSourceRange.getStartLine();
            int n4 = iSourceRange.getEndLine();
            if (n >= n3 && n <= n4) {
                return iCElementArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public ICElement getElementAtOffset(int n) throws CModelException {
        ICElement iCElement = this.getSourceElementAtOffset(n);
        if (iCElement == this) {
            return null;
        }
        return iCElement;
    }

    public ICElement getElement(String string) {
        ICElement[] iCElementArray = this.getChildren();
        int n = 0;
        while (n < iCElementArray.length) {
            if (string.equals(iCElementArray[n].getElementName())) {
                return iCElementArray[n];
            }
            ++n;
        }
        return null;
    }

    public IInclude getInclude(String string) {
        ICElement[] iCElementArray = this.getChildren();
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n].getElementType() == 72 && string.equals(iCElementArray[n].getElementName())) {
                return (IInclude)iCElementArray[n];
            }
            ++n;
        }
        return null;
    }

    public IInclude[] getIncludes() throws CModelException {
        ICElement[] iCElementArray = this.getChildren();
        ArrayList<ICElement> arrayList = new ArrayList<ICElement>();
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n].getElementType() == 72) {
                arrayList.add(iCElementArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IInclude[0]);
    }

    public IUsing getUsing(String string) {
        ICElement[] iCElementArray = this.getChildren();
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n].getElementType() == 62 && string.equals(iCElementArray[n].getElementName())) {
                return (IUsing)iCElementArray[n];
            }
            ++n;
        }
        return null;
    }

    public IUsing[] getUsings() throws CModelException {
        ICElement[] iCElementArray = this.getChildren();
        ArrayList<ICElement> arrayList = new ArrayList<ICElement>();
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n].getElementType() == 62) {
                arrayList.add(iCElementArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IUsing[0]);
    }

    public void setLocation(IPath iPath) {
        this.location = iPath;
    }

    public IPath getLocation() {
        if (this.location == null) {
            IFile iFile = this.getFile();
            if (iFile != null) {
                this.location = iFile.getLocation();
            } else {
                return this.getPath();
            }
        }
        return this.location;
    }

    protected IFile getFile() {
        IResource iResource = this.getResource();
        if (iResource instanceof IFile) {
            return (IFile)iResource;
        }
        return null;
    }

    public void copy(ICElement iCElement, ICElement iCElement2, String string, boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        this.getSourceManipulationInfo().copy(iCElement, iCElement2, string, bl, iProgressMonitor);
    }

    public void delete(boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        this.getSourceManipulationInfo().delete(bl, iProgressMonitor);
    }

    public void move(ICElement iCElement, ICElement iCElement2, String string, boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        this.getSourceManipulationInfo().move(iCElement, iCElement2, string, bl, iProgressMonitor);
    }

    public void rename(String string, boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        this.getSourceManipulationInfo().rename(string, bl, iProgressMonitor);
    }

    public String getSource() throws CModelException {
        return this.getSourceManipulationInfo().getSource();
    }

    public ISourceRange getSourceRange() throws CModelException {
        return this.getSourceManipulationInfo().getSourceRange();
    }

    protected TranslationUnitInfo getTranslationUnitInfo() {
        return (TranslationUnitInfo)this.getElementInfo();
    }

    protected SourceManipulationInfo getSourceManipulationInfo() {
        if (this.sourceManipulationInfo == null) {
            this.sourceManipulationInfo = new SourceManipulationInfo(this);
        }
        return this.sourceManipulationInfo;
    }

    protected CElementInfo createElementInfo() {
        return new TranslationUnitInfo(this);
    }

    protected void buildStructure(OpenableInfo openableInfo, IProgressMonitor iProgressMonitor) throws CModelException {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return;
        }
        this.removeInfo();
        HashMap hashMap = new HashMap(11);
        openableInfo.setIsStructureKnown(this.generateInfos(openableInfo, iProgressMonitor, hashMap, this.getResource()));
        CModelManager.getDefault().getElementsOutOfSynchWithBuffers().remove(this);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            ICElement iCElement = (ICElement)iterator.next();
            Object v = hashMap.get(iCElement);
            CModelManager.getDefault().putInfo(iCElement, v);
        }
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return;
        }
        CModelManager.getDefault().putInfo(this, openableInfo);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ITranslationUnit)) {
            return false;
        }
        return super.equals(object) && !((ITranslationUnit)object).isWorkingCopy();
    }

    public IWorkingCopy findSharedWorkingCopy(IBufferFactory iBufferFactory) {
        Map map;
        Map map2;
        if (iBufferFactory == null) {
            iBufferFactory = BufferManager.getDefaultBufferManager();
        }
        if ((map2 = (Map)(map = CModelManager.getDefault().sharedWorkingCopies).get(iBufferFactory)) == null) {
            return null;
        }
        return (WorkingCopy)map2.get(this);
    }

    private void getNewElements(Map map, CElement cElement) {
        CElementInfo cElementInfo = cElement.getElementInfo();
        if (cElementInfo != null && cElement instanceof IParent) {
            ICElement[] iCElementArray = cElementInfo.getChildren();
            int n = iCElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                CElement cElement2 = (CElement)iCElementArray[n2];
                this.getNewElements(map, cElement2);
                ++n2;
            }
        }
        map.put(cElement, cElementInfo);
    }

    protected boolean generateInfos(OpenableInfo openableInfo, IProgressMonitor iProgressMonitor, Map map, IResource iResource) throws CModelException {
        ITranslationUnit iTranslationUnit;
        IResource iResource2;
        CModelManager.getDefault().putInfo(this, openableInfo);
        TranslationUnitInfo translationUnitInfo = (TranslationUnitInfo)openableInfo;
        Map map2 = this.parse();
        if (map2 == null) {
            this.getNewElements(map, this);
        } else {
            map.putAll(map2);
        }
        if (this.isWorkingCopy() && (iResource2 = (iTranslationUnit = ((IWorkingCopy)((Object)this)).getOriginalElement()).getResource()) != null && iResource2 instanceof IFile) {
            translationUnitInfo.fTimestamp = ((IFile)iResource2).getModificationStamp();
        }
        return translationUnitInfo.isStructureKnown();
    }

    public char[] getContents() {
        try {
            IBuffer iBuffer = this.getBuffer();
            return iBuffer == null ? null : iBuffer.getCharacters();
        }
        catch (CModelException cModelException) {
            return new char[0];
        }
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor iProgressMonitor, IBufferFactory iBufferFactory) throws CModelException {
        WorkingCopy workingCopy;
        if (iBufferFactory == null) {
            iBufferFactory = BufferManager.getDefaultBufferManager();
        }
        CModelManager cModelManager = CModelManager.getDefault();
        Map map = cModelManager.sharedWorkingCopies;
        HashMap<TranslationUnit, WorkingCopy> hashMap = (HashMap<TranslationUnit, WorkingCopy>)map.get(iBufferFactory);
        if (hashMap == null) {
            hashMap = new HashMap<TranslationUnit, WorkingCopy>();
            map.put(iBufferFactory, hashMap);
        }
        if ((workingCopy = (WorkingCopy)hashMap.get(this)) != null) {
            ++workingCopy.useCount;
            return workingCopy;
        }
        workingCopy = (WorkingCopy)this.getWorkingCopy(iProgressMonitor, iBufferFactory);
        hashMap.put(this, workingCopy);
        return workingCopy;
    }

    public IWorkingCopy getWorkingCopy() throws CModelException {
        return this.getWorkingCopy(null, null);
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor iProgressMonitor, IBufferFactory iBufferFactory) throws CModelException {
        WorkingCopy workingCopy = new WorkingCopy(this.getParent(), this.getFile(), iBufferFactory);
        workingCopy.open(iProgressMonitor);
        return workingCopy;
    }

    protected boolean hasBuffer() {
        return true;
    }

    public boolean isConsistent() throws CModelException {
        return CModelManager.getDefault().getElementsOutOfSynchWithBuffers().get(this) == null;
    }

    protected boolean isSourceElement() {
        return true;
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public void makeConsistent(IProgressMonitor iProgressMonitor) throws CModelException {
        this.makeConsistent(iProgressMonitor, false);
    }

    public void makeConsistent(IProgressMonitor iProgressMonitor, boolean bl) throws CModelException {
        if (!this.isConsistent() || bl) {
            OpenableInfo openableInfo = (OpenableInfo)this.createElementInfo();
            this.buildStructure(openableInfo, iProgressMonitor);
        }
    }

    protected IBuffer openBuffer(IProgressMonitor iProgressMonitor) throws CModelException {
        IResource iResource;
        BufferManager bufferManager = this.getBufferManager();
        IBuffer iBuffer = this.getBufferFactory().createBuffer(this);
        if (iBuffer == null) {
            return null;
        }
        if (iBuffer.getCharacters() == null && (iResource = this.getResource()) != null && iResource.getType() == 1) {
            iBuffer.setContents(Util.getResourceContentsAsCharArray((IFile)iResource));
        }
        bufferManager.addBuffer(iBuffer);
        iBuffer.addBufferChangedListener(this);
        return iBuffer;
    }

    public Map parse() {
        try {
            this.removeChildren();
            CModelBuilder cModelBuilder = new CModelBuilder(this);
            boolean bl = !CCorePlugin.getDefault().useStructuralParseMode();
            return cModelBuilder.parse(bl);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

