/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.IOException;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.BinaryObjectAdapter;
import org.eclipse.core.runtime.IPath;

public class Symbol
implements IBinaryParser.ISymbol,
Comparable {
    BinaryObjectAdapter binary;
    long timestamp;
    Addr2line addr2line;
    public IPath filename;
    public int startLine;
    public int endLine;
    public long addr;
    public String name;
    public int type;
    public long size;

    public Symbol(BinaryObjectAdapter binaryObjectAdapter) {
        this.binary = binaryObjectAdapter;
    }

    public IPath getFilename() {
        return this.filename;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public long getAddress() {
        return this.addr;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getLineNumber(long l) {
        int n = -1;
        try {
            Addr2line addr2line = this.startAddr2Line();
            if (addr2line != null) {
                n = addr2line.getLineNumber(this.addr + l);
            }
        }
        catch (IOException iOException) {}
        return n;
    }

    public long getSize() {
        return this.size;
    }

    public int compareTo(Object object) {
        long l = 0L;
        long l2 = 0L;
        if (object instanceof Symbol) {
            Symbol symbol = (Symbol)object;
            l = this.addr;
            l2 = symbol.addr;
        } else if (object instanceof Long) {
            Long l3 = (Long)object;
            l2 = l3;
            l = this.addr;
        }
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    synchronized Addr2line startAddr2Line() {
        if (this.addr2line == null) {
            this.addr2line = this.binary.getAddr2line();
            if (this.addr2line != null) {
                this.timestamp = System.currentTimeMillis();
                Runnable runnable = new Runnable(){

                    public void run() {
                        long l = System.currentTimeMillis() - Symbol.this.timestamp;
                        while (l < 10000L) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                            l = System.currentTimeMillis() - Symbol.this.timestamp;
                        }
                        Symbol.this.stopAddr2Line();
                    }
                };
                new Thread(runnable, "Addr2line Reaper").start();
            }
        } else {
            this.timestamp = System.currentTimeMillis();
        }
        return this.addr2line;
    }

    synchronized void stopAddr2Line() {
        if (this.addr2line != null) {
            this.addr2line.dispose();
        }
        this.addr2line = null;
    }
}

