/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.tools;

import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.debug.dwarf.Dwarf;
import org.eclipse.cdt.utils.debug.stabs.Stabs;
import org.eclipse.cdt.utils.debug.tools.DebugSym;
import org.eclipse.cdt.utils.debug.tools.DebugSymsRequestor;
import org.eclipse.cdt.utils.elf.Elf;

public class DebugAddr2line {
    DebugSymsRequestor symreq;

    public DebugAddr2line(String string) throws IOException {
        Elf elf = new Elf(string);
        this.init(elf);
        elf.dispose();
    }

    public DebugAddr2line(Elf elf) throws IOException {
        this.init(elf);
    }

    void init(Elf elf) throws IOException {
        this.symreq = new DebugSymsRequestor();
        Elf.Attribute attribute = elf.getAttributes();
        int n = attribute.getDebugType();
        if (n == 1) {
            Stabs stabs = new Stabs(elf);
            stabs.parse(this.symreq);
        } else if (n == 2) {
            Dwarf dwarf = new Dwarf(elf);
            dwarf.parse(this.symreq);
        } else {
            throw new IOException(CCorePlugin.getResourceString("Util.unknownFormat"));
        }
    }

    public void dispose() {
    }

    public int getStartLine(long l) throws IOException {
        DebugSym debugSym = this.symreq.getEntry(l);
        if (debugSym != null) {
            return debugSym.startLine;
        }
        return 0;
    }

    public int getEndLine(long l) throws IOException {
        DebugSym debugSym = this.symreq.getEntry(l);
        if (debugSym != null) {
            return debugSym.endLine;
        }
        return 0;
    }

    public String getFunction(long l) throws IOException {
        DebugSym debugSym = this.symreq.getEntry(l);
        if (debugSym != null) {
            return debugSym.name;
        }
        return null;
    }

    public String getFileName(long l) throws IOException {
        DebugSym debugSym = this.symreq.getEntry(l);
        if (debugSym != null) {
            return debugSym.filename;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            DebugAddr2line debugAddr2line = new DebugAddr2line(stringArray[0]);
            long l = Integer.decode(stringArray[1]).longValue();
            int n = debugAddr2line.getStartLine(l);
            int n2 = debugAddr2line.getEndLine(l);
            String string = debugAddr2line.getFunction(l);
            String string2 = debugAddr2line.getFileName(l);
            System.out.println(Long.toHexString(l));
            System.out.println(String.valueOf(string2) + ":" + string + ":" + n + ":" + n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

