/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;

public class MIVarUpdateInfo
extends MIInfo {
    MIVarChange[] changeList;

    public MIVarUpdateInfo(MIOutput mIOutput) {
        super(mIOutput);
        this.parse();
    }

    public MIVarChange[] getMIVarChanges() {
        return this.changeList;
    }

    void parse() {
        MIOutput mIOutput;
        MIResultRecord mIResultRecord;
        ArrayList arrayList = new ArrayList();
        if (this.isDone() && (mIResultRecord = (mIOutput = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] mIResultArray = mIResultRecord.getMIResults();
            int n = 0;
            while (n < mIResultArray.length) {
                MIValue mIValue;
                String string = mIResultArray[n].getVariable();
                if (string.equals("changelist") && (mIValue = mIResultArray[n].getMIValue()) instanceof MITuple) {
                    this.parseChangeList((MITuple)mIValue, arrayList);
                }
                ++n;
            }
        }
        this.changeList = arrayList.toArray(new MIVarChange[arrayList.size()]);
    }

    void parseChangeList(MITuple mITuple, List list) {
        MIResult[] mIResultArray = mITuple.getMIResults();
        MIVarChange mIVarChange = null;
        int n = 0;
        while (n < mIResultArray.length) {
            String string = mIResultArray[n].getVariable();
            MIValue mIValue = mIResultArray[n].getMIValue();
            String string2 = "";
            if (mIValue instanceof MIConst) {
                string2 = ((MIConst)mIValue).getString();
            }
            if (string.equals("name")) {
                mIVarChange = new MIVarChange(string2);
                list.add(mIVarChange);
            } else if (string.equals("in_scope")) {
                if (mIVarChange != null) {
                    mIVarChange.setInScope("true".equals(string2));
                }
            } else if (string.equals("type_changed") && mIVarChange != null) {
                mIVarChange.setChanged("true".equals(string2));
            }
            ++n;
        }
    }
}

