/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.Reader;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.IFilenameProvider;
import org.eclipse.cdt.core.parser.ILineOffsetReconciler;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IPreprocessor;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.extension.ExtensionDialect;
import org.eclipse.cdt.core.parser.extension.IParserExtensionFactory;
import org.eclipse.cdt.internal.core.parser.CompleteParser;
import org.eclipse.cdt.internal.core.parser.CompletionParser;
import org.eclipse.cdt.internal.core.parser.ParserExtensionFactory;
import org.eclipse.cdt.internal.core.parser.QuickParseCallback;
import org.eclipse.cdt.internal.core.parser.QuickParser;
import org.eclipse.cdt.internal.core.parser.SelectionParser;
import org.eclipse.cdt.internal.core.parser.StructuralParseCallback;
import org.eclipse.cdt.internal.core.parser.StructuralParser;
import org.eclipse.cdt.internal.core.parser.ast.complete.CompleteParseASTFactory;
import org.eclipse.cdt.internal.core.parser.ast.expression.ExpressionParseASTFactory;
import org.eclipse.cdt.internal.core.parser.ast.quick.QuickParseASTFactory;
import org.eclipse.cdt.internal.core.parser.scanner.LineOffsetReconciler;
import org.eclipse.cdt.internal.core.parser.scanner.Preprocessor;
import org.eclipse.cdt.internal.core.parser.scanner.Scanner;

public class ParserFactory {
    private static IParserExtensionFactory extensionFactory = new ParserExtensionFactory(ExtensionDialect.GCC);
    private static IParserLogService defaultLogService = new DefaultLogService();

    public static IASTFactory createASTFactory(IFilenameProvider iFilenameProvider, ParserMode parserMode, ParserLanguage parserLanguage) {
        if (parserMode == ParserMode.QUICK_PARSE) {
            return new QuickParseASTFactory(extensionFactory.createASTExtensionFactory(ParserMode.QUICK_PARSE));
        }
        if (parserMode == ParserMode.EXPRESSION_PARSE) {
            return new ExpressionParseASTFactory(extensionFactory.createASTExtensionFactory(ParserMode.EXPRESSION_PARSE));
        }
        return new CompleteParseASTFactory(iFilenameProvider, parserLanguage, parserMode, extensionFactory.createASTExtensionFactory(ParserMode.COMPLETE_PARSE));
    }

    public static IParser createParser(IScanner iScanner, ISourceElementRequestor iSourceElementRequestor, ParserMode parserMode, ParserLanguage parserLanguage, IParserLogService iParserLogService) throws ParserFactoryError {
        ISourceElementRequestor iSourceElementRequestor2;
        if (iScanner == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_SCANNER);
        }
        if (parserLanguage == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_LANGUAGE);
        }
        IParserLogService iParserLogService2 = iParserLogService == null ? ParserFactory.createDefaultLogService() : iParserLogService;
        ParserMode parserMode2 = parserMode == null ? ParserMode.COMPLETE_PARSE : parserMode;
        ISourceElementRequestor iSourceElementRequestor3 = iSourceElementRequestor2 = iSourceElementRequestor == null ? new NullSourceElementRequestor() : iSourceElementRequestor;
        if (parserMode2 == ParserMode.COMPLETE_PARSE) {
            return new CompleteParser(iScanner, iSourceElementRequestor2, parserLanguage, iParserLogService2);
        }
        if (parserMode2 == ParserMode.STRUCTURAL_PARSE) {
            return new StructuralParser(iScanner, iSourceElementRequestor2, parserLanguage, iParserLogService2);
        }
        if (parserMode2 == ParserMode.COMPLETION_PARSE) {
            return new CompletionParser(iScanner, iSourceElementRequestor2, parserLanguage, iParserLogService2);
        }
        if (parserMode2 == ParserMode.SELECTION_PARSE) {
            return new SelectionParser(iScanner, iSourceElementRequestor2, parserLanguage, iParserLogService2);
        }
        return new QuickParser(iScanner, iSourceElementRequestor2, parserLanguage, iParserLogService2);
    }

    public static IScanner createScanner(Reader reader, String string, IScannerInfo iScannerInfo, ParserMode parserMode, ParserLanguage parserLanguage, ISourceElementRequestor iSourceElementRequestor, IParserLogService iParserLogService) throws ParserFactoryError {
        if (reader == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_READER);
        }
        if (string == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_FILENAME);
        }
        if (iScannerInfo == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_CONFIG);
        }
        if (parserLanguage == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_LANGUAGE);
        }
        IParserLogService iParserLogService2 = iParserLogService == null ? ParserFactory.createDefaultLogService() : iParserLogService;
        ParserMode parserMode2 = parserMode == null ? ParserMode.COMPLETE_PARSE : parserMode;
        ISourceElementRequestor iSourceElementRequestor2 = iSourceElementRequestor == null ? new NullSourceElementRequestor() : iSourceElementRequestor;
        Scanner scanner = new Scanner(reader, string, iScannerInfo, iSourceElementRequestor2, parserMode2, parserLanguage, iParserLogService2, extensionFactory.createScannerExtension());
        return scanner;
    }

    public static IPreprocessor createPreprocessor(Reader reader, String string, IScannerInfo iScannerInfo, ParserMode parserMode, ParserLanguage parserLanguage, ISourceElementRequestor iSourceElementRequestor, IParserLogService iParserLogService) {
        if (reader == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_READER);
        }
        if (string == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_FILENAME);
        }
        if (iScannerInfo == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_CONFIG);
        }
        if (parserLanguage == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_LANGUAGE);
        }
        IParserLogService iParserLogService2 = iParserLogService == null ? ParserFactory.createDefaultLogService() : iParserLogService;
        ParserMode parserMode2 = parserMode == null ? ParserMode.COMPLETE_PARSE : parserMode;
        ISourceElementRequestor iSourceElementRequestor2 = iSourceElementRequestor == null ? new NullSourceElementRequestor() : iSourceElementRequestor;
        Preprocessor preprocessor = new Preprocessor(reader, string, iScannerInfo, iSourceElementRequestor2, parserMode2, parserLanguage, iParserLogService2, extensionFactory.createScannerExtension());
        return preprocessor;
    }

    public static ILineOffsetReconciler createLineOffsetReconciler(Reader reader) {
        return new LineOffsetReconciler(reader);
    }

    public static IQuickParseCallback createQuickParseCallback() {
        return new QuickParseCallback();
    }

    public static IQuickParseCallback createStructuralParseCallback() {
        return new StructuralParseCallback();
    }

    public static IParserLogService createDefaultLogService() {
        return defaultLogService;
    }
}

