/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTReferenceStore;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTVariable
extends ASTSymbol
implements IASTVariable {
    private final IASTExpression constructorExpression;
    protected final ASTReferenceStore referenceDelegate;
    private final ASTQualifiedNamedElement qualifiedName;
    private NamedOffsets offsets = new NamedOffsets();
    private final IASTExpression bitfieldExpression;
    private final IASTInitializerClause initializerClause;
    private final IASTAbstractDeclaration abstractDeclaration;

    public ASTVariable(ISymbol iSymbol, IASTAbstractDeclaration iASTAbstractDeclaration, IASTInitializerClause iASTInitializerClause, IASTExpression iASTExpression, int n, int n2, int n3, int n4, int n5, List list, IASTExpression iASTExpression2, boolean bl) {
        super(iSymbol);
        this.abstractDeclaration = iASTAbstractDeclaration;
        this.initializerClause = iASTInitializerClause;
        this.bitfieldExpression = iASTExpression;
        this.constructorExpression = iASTExpression2;
        this.setStartingOffsetAndLineNumber(n, n2);
        this.setNameOffset(n3);
        this.setNameEndOffsetAndLineNumber(n4, n5);
        this.referenceDelegate = new ASTReferenceStore(list);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), iSymbol.getName());
    }

    public boolean isAuto() {
        return this.symbol.getTypeInfo().checkBit(32);
    }

    public boolean isRegister() {
        return this.symbol.getTypeInfo().checkBit(64);
    }

    public boolean isStatic() {
        return this.symbol.getTypeInfo().checkBit(128);
    }

    public boolean isExtern() {
        return this.symbol.getTypeInfo().checkBit(256);
    }

    public boolean isMutable() {
        return this.symbol.getTypeInfo().checkBit(512);
    }

    public IASTAbstractDeclaration getAbstractDeclaration() {
        return this.abstractDeclaration;
    }

    public String getName() {
        return this.getSymbol().getName();
    }

    public IASTInitializerClause getInitializerClause() {
        return this.initializerClause;
    }

    public boolean isBitfield() {
        return this.bitfieldExpression != null;
    }

    public IASTExpression getBitfieldExpression() {
        return this.bitfieldExpression;
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int n) {
        this.offsets.setNameOffset(n);
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public IASTScope getOwnerScope() {
        return (IASTScope)((Object)this.getSymbol().getContainingSymbol().getASTExtension().getPrimaryDeclaration());
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor) {
        try {
            iSourceElementRequestor.acceptVariable(this);
        }
        catch (Exception exception) {}
        this.referenceDelegate.processReferences(iSourceElementRequestor);
        if (this.initializerClause != null) {
            this.initializerClause.acceptElement(iSourceElementRequestor);
        }
        if (this.constructorExpression != null) {
            this.constructorExpression.acceptElement(iSourceElementRequestor);
        }
        if (this.getAbstractDeclaration() != null) {
            this.getAbstractDeclaration().acceptElement(iSourceElementRequestor);
        }
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor) {
    }

    public void setStartingOffsetAndLineNumber(int n, int n2) {
        this.offsets.setStartingOffsetAndLineNumber(n, n2);
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.offsets.setEndingOffsetAndLineNumber(n, n2);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.offsets.setNameEndOffsetAndLineNumber(n, n2);
    }

    public IASTExpression getConstructorExpression() {
        return this.constructorExpression;
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }
}

