/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateFactory;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class TemplateFactory
implements ITemplateFactory {
    private Set templateFunctions;
    private List templatesList;
    private List parametersList;
    private List argumentsList;

    protected TemplateFactory(ITemplateSymbol iTemplateSymbol, List list, List list2) {
        this.templatesList = new LinkedList();
        this.templatesList.add(iTemplateSymbol);
        this.parametersList = new LinkedList();
        this.parametersList.add(new LinkedList(list));
        this.argumentsList = new LinkedList();
        this.argumentsList.add(list2 != null ? new LinkedList(list2) : new LinkedList());
    }

    protected TemplateFactory(List list, List list2, List list3) {
        this.templatesList = list;
        this.parametersList = list2;
        this.argumentsList = list3;
    }

    protected TemplateFactory(Set set, List list, List list2) {
        this.templatesList = new LinkedList();
        this.templateFunctions = set;
        this.parametersList = new LinkedList();
        this.parametersList.add(new LinkedList(list));
        this.argumentsList = new LinkedList();
        this.argumentsList.add(list2 != null ? new LinkedList(list2) : new LinkedList());
    }

    public ITemplateFactory lookupTemplateForMemberDefinition(String string, List list, List list2) throws ParserSymbolTableException {
        if (this.templatesList == null || this.templatesList.isEmpty()) {
            return null;
        }
        ITemplateSymbol iTemplateSymbol = (ITemplateSymbol)this.templatesList.get(0);
        IContainerSymbol iContainerSymbol = iTemplateSymbol.getTemplatedSymbol();
        ParserSymbolTable.LookupData lookupData = new ParserSymbolTable.LookupData(string, TypeInfo.t_any);
        ParserSymbolTable.lookup(lookupData, iContainerSymbol);
        ISymbol iSymbol = ParserSymbolTable.resolveAmbiguities(lookupData);
        if (iSymbol.getContainingSymbol() instanceof ITemplateSymbol && (iTemplateSymbol = TemplateEngine.selectTemplateOrSpecialization((ITemplateSymbol)iSymbol.getContainingSymbol(), list, list2)) != null) {
            LinkedList<ITemplateSymbol> linkedList = new LinkedList<ITemplateSymbol>(this.templatesList);
            LinkedList linkedList2 = new LinkedList(this.parametersList);
            LinkedList linkedList3 = new LinkedList(this.argumentsList);
            linkedList.add(iTemplateSymbol);
            linkedList2.add(new LinkedList(list));
            linkedList3.add(list2 != null ? new LinkedList(list2) : new LinkedList());
            return new TemplateFactory(linkedList, linkedList2, linkedList3);
        }
        return null;
    }

    public void addSymbol(ISymbol iSymbol) throws ParserSymbolTableException {
        IContainerSymbol iContainerSymbol;
        Cloneable cloneable;
        if (((List)this.getParametersList().get(0)).isEmpty()) {
            this.addExplicitSpecialization(iSymbol);
            return;
        }
        Iterator iterator = this.getTemplatesList().iterator();
        Iterator iterator2 = this.getParametersList().iterator();
        while (iterator.hasNext()) {
            cloneable = new HashMap();
            iContainerSymbol = (ITemplateSymbol)iterator.next();
            Iterator iterator3 = iContainerSymbol.getParameterList().iterator();
            if (!iterator2.hasNext()) {
                throw new ParserSymbolTableError(-1);
            }
            List list = (List)iterator2.next();
            Iterator iterator4 = list.iterator();
            while (iterator4.hasNext()) {
                ISymbol iSymbol2 = (ISymbol)iterator4.next();
                ISymbol iSymbol3 = (ISymbol)iterator3.next();
                cloneable.put(iSymbol2, iSymbol3);
            }
            iContainerSymbol.getDefinitionParameterMap().put(iSymbol, cloneable);
        }
        cloneable = (ITemplateSymbol)this.getTemplatesList().get(this.getTemplatesList().size() - 1);
        iContainerSymbol = cloneable.getTemplatedSymbol();
        if (iContainerSymbol.isForwardDeclaration() && iContainerSymbol.getTypeSymbol() == iSymbol) {
            cloneable.addSymbol(iSymbol);
        } else {
            iContainerSymbol.addSymbol(iSymbol);
        }
    }

    private void addExplicitSpecialization(ISymbol iSymbol) throws ParserSymbolTableException {
        Object object;
        Iterator iterator = this.getTemplatesList().iterator();
        Iterator iterator2 = this.getArgumentsList().iterator();
        while (iterator.hasNext()) {
            object = (ITemplateSymbol)iterator.next();
            object.addExplicitSpecialization(iSymbol, (List)iterator2.next());
        }
        if (this.getTemplateFunctions() != null && iterator2.hasNext()) {
            object = (List)iterator2.next();
            ITemplateSymbol iTemplateSymbol = TemplateEngine.resolveTemplateFunctions(this.getTemplateFunctions(), (List)object, iSymbol);
            if (iTemplateSymbol != null) {
                iTemplateSymbol.addExplicitSpecialization(iSymbol, (List)object);
            } else {
                throw new ParserSymbolTableException(4);
            }
        }
    }

    public ISymbol lookupMemberForDefinition(String string) throws ParserSymbolTableException {
        if (this.getTemplateFunctions() != null) {
            throw new ParserSymbolTableException(0);
        }
        Set set = this.getPrimaryTemplate().getContainedSymbols().keySet();
        IContainerSymbol iContainerSymbol = (IContainerSymbol)this.getPrimaryTemplate().getContainedSymbols().get(set.iterator().next());
        return iContainerSymbol.lookupMemberForDefinition(string);
    }

    public IParameterizedSymbol lookupMemberFunctionForDefinition(String string, List list) throws ParserSymbolTableException {
        if (this.getTemplateFunctions() != null) {
            throw new ParserSymbolTableException(0);
        }
        Set set = this.getPrimaryTemplate().getContainedSymbols().keySet();
        IContainerSymbol iContainerSymbol = (IContainerSymbol)this.getPrimaryTemplate().getContainedSymbols().get(set.iterator().next());
        return iContainerSymbol.lookupMethodForDefinition(string, list);
    }

    public ITemplateSymbol getPrimaryTemplate() {
        return (ITemplateSymbol)this.templatesList.get(0);
    }

    public ISymbol lookupParam(String string) throws ParserSymbolTableException {
        Iterator iterator = this.getParametersList().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                ISymbol iSymbol = (ISymbol)iterator2.next();
                if (!iSymbol.getName().equals(string)) continue;
                return iSymbol;
            }
        }
        return this.getPrimaryTemplate().lookup(string);
    }

    protected List getTemplatesList() {
        return this.templatesList;
    }

    protected List getParametersList() {
        return this.parametersList;
    }

    protected List getArgumentsList() {
        return this.argumentsList;
    }

    protected Set getTemplateFunctions() {
        return this.templateFunctions;
    }
}

