/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.util.StringMatcher;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class CElementFilters {
    static List definedFilters = null;
    static List defaultFilters = null;
    static StringMatcher[] matchers = null;
    static String FILTERS_TAG = "CElementFilters";
    static String COMMA_SEPARATOR = ",";

    public static List getDefaultFilters() {
        if (defaultFilters == null) {
            CElementFilters.readFilters();
        }
        return defaultFilters;
    }

    public static List getDefinedFilters() {
        if (definedFilters == null) {
            CUIPlugin cUIPlugin = CUIPlugin.getDefault();
            String string = cUIPlugin.getPluginPreferences().getString(FILTERS_TAG);
            if (string.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, COMMA_SEPARATOR);
                definedFilters = new ArrayList();
                while (stringTokenizer.hasMoreElements()) {
                    String string2 = stringTokenizer.nextToken();
                    definedFilters.add(string2);
                }
            } else {
                CElementFilters.readFilters();
            }
        }
        return definedFilters;
    }

    public static StringMatcher[] getMatchers() {
        if (matchers == null) {
            List list = CElementFilters.getDefinedFilters();
            matchers = new StringMatcher[list.size()];
            int n = 0;
            while (n < matchers.length) {
                CElementFilters.matchers[n] = new StringMatcher((String)list.get(n), true, false);
                ++n;
            }
        }
        return matchers;
    }

    public static void setPatterns(String[] stringArray) {
        matchers = new StringMatcher[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            CElementFilters.matchers[n] = new StringMatcher(stringArray[n], true, false);
            ++n;
        }
    }

    public static boolean match(String string) {
        StringMatcher[] stringMatcherArray = CElementFilters.getMatchers();
        if (stringMatcherArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringMatcherArray.length) {
            if (stringMatcherArray[n].match(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private CElementFilters() {
    }

    static void readFilters() {
        IExtensionPoint iExtensionPoint;
        definedFilters = new ArrayList();
        defaultFilters = new ArrayList();
        CUIPlugin cUIPlugin = CUIPlugin.getDefault();
        if (cUIPlugin != null && (iExtensionPoint = cUIPlugin.getDescriptor().getExtensionPoint(FILTERS_TAG)) != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    String string;
                    String string2 = iConfigurationElementArray[n2].getAttribute("pattern");
                    if (string2 != null) {
                        definedFilters.add(string2);
                    }
                    if ((string = iConfigurationElementArray[n2].getAttribute("selected")) != null && string.equalsIgnoreCase("true")) {
                        defaultFilters.add(string2);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }
}

