/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.io.StringWriter;
import org.eclipse.cdt.internal.ui.cview.CElementFilters;
import org.eclipse.cdt.internal.ui.cview.CPatternFilter;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.internal.ui.cview.FiltersContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;

class FilterSelectionAction
extends SelectionProviderAction {
    private CView cview;
    private Shell shell;

    public FilterSelectionAction(Shell shell, CView cView, String string) {
        super((ISelectionProvider)cView.getViewer(), string);
        this.setToolTipText(CViewMessages.getString("FilterSelectionAction.toolTip"));
        this.setEnabled(true);
        this.shell = shell;
        this.cview = cView;
    }

    public void run() {
        CPatternFilter cPatternFilter = this.cview.getPatternFilter();
        FiltersContentProvider filtersContentProvider = new FiltersContentProvider(cPatternFilter);
        ListSelectionDialog listSelectionDialog = new ListSelectionDialog(this.shell, (Object)this.cview.getViewer(), (IStructuredContentProvider)filtersContentProvider, (ILabelProvider)new LabelProvider(), CViewMessages.getString("FilterSelectionAction.selectFilters"));
        listSelectionDialog.setInitialSelections((Object[])filtersContentProvider.getInitialSelections());
        listSelectionDialog.setTitle(CViewMessages.getString("FilterSelectionAction.title"));
        listSelectionDialog.open();
        if (listSelectionDialog.getReturnCode() == 0) {
            Object[] objectArray = listSelectionDialog.getResult();
            String[] stringArray = new String[objectArray.length];
            System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
            cPatternFilter.setPatterns(stringArray);
            CElementFilters.setPatterns(stringArray);
            this.saveInPreferences(stringArray);
            TreeViewer treeViewer = this.cview.getViewer();
            treeViewer.getControl().setRedraw(false);
            treeViewer.refresh();
            treeViewer.getControl().setRedraw(true);
        }
    }

    private void saveInPreferences(String[] stringArray) {
        CUIPlugin cUIPlugin = CUIPlugin.getDefault();
        StringWriter stringWriter = new StringWriter();
        int n = 0;
        while (n < stringArray.length) {
            stringWriter.write(stringArray[n]);
            stringWriter.write(CPatternFilter.COMMA_SEPARATOR);
            ++n;
        }
        cUIPlugin.getPreferenceStore().setValue(CPatternFilter.FILTERS_TAG, stringWriter.toString());
    }
}

