/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.GotoErrorAction;
import org.eclipse.cdt.internal.ui.editor.TogglePresentationAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.ui.texteditor.TextEditorAction;

public class CEditorActionContributor
extends TextEditorActionContributor {
    protected CEditor fCEditor;
    protected RetargetTextEditorAction fContentAssist;
    protected RetargetTextEditorAction fAddInclude;
    protected RetargetTextEditorAction fOpenOnSelection;
    protected SelectionAction fShiftLeft;
    protected SelectionAction fShiftRight;
    private TogglePresentationAction fTogglePresentation;
    private GotoErrorAction fPreviousError;
    private GotoErrorAction fNextError;

    public CEditorActionContributor() {
        ResourceBundle resourceBundle = CEditorMessages.getResourceBundle();
        this.fShiftRight = new SelectionAction("ShiftRight.", 8);
        this.fShiftRight.setActionDefinitionId("org.eclipse.ui.edit.text.shiftRight");
        CPluginImages.setImageDescriptors((IAction)this.fShiftRight, "lcl16/", "org.eclipse.cdt.ui.shift_r_edit.gif");
        this.fShiftLeft = new SelectionAction("ShiftLeft.", 9);
        this.fShiftLeft.setActionDefinitionId("org.eclipse.ui.edit.text.shiftLeft");
        CPluginImages.setImageDescriptors((IAction)this.fShiftLeft, "lcl16/", "org.eclipse.cdt.ui.shift_l_edit.gif");
        this.fContentAssist = new RetargetTextEditorAction(resourceBundle, "ContentAssistProposal.");
        this.fContentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        CPluginImages.setImageDescriptors((IAction)this.fContentAssist, "tool16/", "org.eclipse.cdt.ui.collapseall.gif");
        this.fAddInclude = new RetargetTextEditorAction(resourceBundle, "AddIncludeOnSelection.");
        this.fAddInclude.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.add.include");
        this.fOpenOnSelection = new RetargetTextEditorAction(resourceBundle, "OpenOnSelection.");
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.toggle.presentation");
        this.fPreviousError = new GotoErrorAction("PreviousError.", false);
        this.fPreviousError.setActionDefinitionId("org.eclipse.ui.navigate.previous");
        CPluginImages.setImageDescriptors((IAction)this.fPreviousError, "tool16/", "org.eclipse.cdt.ui.prev_error_nav.gif");
        this.fNextError = new GotoErrorAction("NextError.", true);
        this.fNextError.setActionDefinitionId("org.eclipse.ui.navigate.next");
        CPluginImages.setImageDescriptors((IAction)this.fNextError, "tool16/", "org.eclipse.cdt.ui.next_error_nav.gif");
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
        super.contributeToMenu(iMenuManager);
        IMenuManager iMenuManager2 = iMenuManager.findMenuUsingPath("edit");
        if (iMenuManager2 != null) {
            iMenuManager2.add((IAction)this.fShiftRight);
            iMenuManager2.add((IAction)this.fShiftLeft);
            iMenuManager2.add((IContributionItem)new Separator("group.open"));
            iMenuManager2.add((IAction)this.fNextError);
            iMenuManager2.add((IAction)this.fPreviousError);
            iMenuManager2.add((IContributionItem)new Separator("group.generate"));
            iMenuManager2.appendToGroup("group.generate", (IAction)this.fContentAssist);
            iMenuManager2.appendToGroup("group.generate", (IAction)this.fAddInclude);
            iMenuManager2.appendToGroup("group.generate", (IAction)this.fOpenOnSelection);
        }
    }

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
        super.contributeToToolBar(iToolBarManager);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.fTogglePresentation);
        iToolBarManager.add((IAction)this.fNextError);
        iToolBarManager.add((IAction)this.fPreviousError);
    }

    public void setActiveEditor(IEditorPart iEditorPart) {
        super.setActiveEditor(iEditorPart);
        ITextEditor iTextEditor = null;
        if (iEditorPart instanceof ITextEditor) {
            iTextEditor = (ITextEditor)iEditorPart;
        }
        this.fShiftRight.setEditor(iTextEditor);
        this.fShiftLeft.setEditor(iTextEditor);
        this.fNextError.setEditor(iTextEditor);
        this.fPreviousError.setEditor(iTextEditor);
        this.fTogglePresentation.setEditor(iTextEditor);
        this.fContentAssist.setAction(this.getAction(iTextEditor, "ContentAssistProposal"));
        this.fAddInclude.setAction(this.getAction(iTextEditor, "AddIncludeOnSelection"));
        this.fOpenOnSelection.setAction(this.getAction(iTextEditor, "OpenOnSelection"));
    }

    public void contributeeToStatusLine(IStatusLineManager iStatusLineManager) {
        super.contributeToStatusLine(iStatusLineManager);
    }

    protected static class SelectionAction
    extends TextEditorAction
    implements ISelectionChangedListener {
        protected int fOperationCode;
        protected ITextOperationTarget fOperationTarget = null;
        static /* synthetic */ Class class$0;

        public SelectionAction(String string, int n) {
            super(CEditorMessages.getResourceBundle(), string, null);
            this.fOperationCode = n;
            this.setEnabled(false);
        }

        public void setEditor(ITextEditor iTextEditor) {
            ISelectionProvider iSelectionProvider;
            if (this.getTextEditor() != null && (iSelectionProvider = this.getTextEditor().getSelectionProvider()) != null) {
                iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            super.setEditor(iTextEditor);
            if (iTextEditor != null) {
                Class<?> clazz;
                iSelectionProvider = iTextEditor.getSelectionProvider();
                if (iSelectionProvider != null) {
                    iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
                }
                if ((clazz = class$0) == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.fOperationTarget = (ITextOperationTarget)iTextEditor.getAdapter((Class)clazz);
            } else {
                this.fOperationTarget = null;
            }
            this.selectionChanged(null);
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            boolean bl = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(bl);
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

