/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.opentype.dialogs;

import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.ui.opentype.dialogs.TypeSelectionDialog;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class OpenTypeSelectionDialog
extends TypeSelectionDialog {
    public static final int IN_HIERARCHY = 1025;
    private Point fLocation;
    private Point fSize;

    public OpenTypeSelectionDialog(Shell shell, IRunnableContext iRunnableContext, ICSearchScope iCSearchScope) {
        super(shell, iRunnableContext, iCSearchScope);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    public boolean close() {
        this.writeSettings();
        return super.close();
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.readSettings();
        return control;
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        if (this.fSize != null) {
            point.x = Math.max(point.x, this.fSize.x);
            point.y = Math.max(point.y, this.fSize.y);
            Rectangle rectangle = this.getShell().getDisplay().getClientArea();
            point.x = Math.min(point.x, rectangle.width);
            point.y = Math.min(point.y, rectangle.height);
        }
        return point;
    }

    protected Point getInitialLocation(Point point) {
        Point point2 = super.getInitialLocation(point);
        if (this.fLocation != null) {
            int n;
            point2.x = this.fLocation.x;
            point2.y = this.fLocation.y;
            Rectangle rectangle = this.getShell().getDisplay().getClientArea();
            int n2 = point2.x + point.x;
            if (n2 > rectangle.width) {
                point2.x -= n2 - rectangle.width;
            }
            if ((n = point2.y + point.y) > rectangle.height) {
                point2.y -= n - rectangle.height;
            }
        }
        return point2;
    }

    private void readSettings() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        try {
            int n = iDialogSettings.getInt("x");
            int n2 = iDialogSettings.getInt("y");
            this.fLocation = new Point(n, n2);
            int n3 = iDialogSettings.getInt("width");
            int n4 = iDialogSettings.getInt("height");
            this.fSize = new Point(n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
            this.fSize = null;
        }
    }

    private void writeSettings() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        Point point = this.getShell().getLocation();
        iDialogSettings.put("x", point.x);
        iDialogSettings.put("y", point.y);
        Point point2 = this.getShell().getSize();
        iDialogSettings.put("width", point2.x);
        iDialogSettings.put("height", point2.y);
    }

    private IDialogSettings getDialogSettings() {
        String string;
        IDialogSettings iDialogSettings = CUIPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(string = ((Object)((Object)this)).getClass().getName());
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(string);
        }
        return iDialogSettings2;
    }
}

