/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class CCommentAutoIndentStrategy
extends DefaultAutoIndentStrategy {
    private boolean endsWithDelimiter(IDocument iDocument, String string) {
        String[] stringArray = iDocument.getLegalLineDelimiters();
        int n = 0;
        while (n < stringArray.length) {
            if (string.endsWith(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void jdocIndentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset == -1 || iDocument.getLength() == 0) {
            return;
        }
        try {
            int n = documentCommand.offset == iDocument.getLength() ? documentCommand.offset - 1 : documentCommand.offset;
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset();
            int n3 = this.findEndOfWhiteSpace(iDocument, n2, documentCommand.offset);
            StringBuffer stringBuffer = new StringBuffer(documentCommand.text);
            if (n3 >= n2) {
                stringBuffer.append(iDocument.get(n2, n3 - n2));
                if (n3 < documentCommand.offset) {
                    if (iDocument.getChar(n3) == '/') {
                        stringBuffer.append(" * ");
                    } else if (iDocument.getChar(n3) == '*') {
                        stringBuffer.append("* ");
                    }
                }
            }
            documentCommand.text = stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    protected void jdocIndentForCommentEnd(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset < 2 || iDocument.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(iDocument.get(documentCommand.offset - 2, 2))) {
                ++documentCommand.length;
                --documentCommand.offset;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.length == 0 && documentCommand.text != null && this.endsWithDelimiter(iDocument, documentCommand.text)) {
            this.jdocIndentAfterNewLine(iDocument, documentCommand);
        } else if ("/".equals(documentCommand.text)) {
            this.jdocIndentForCommentEnd(iDocument, documentCommand);
        }
    }
}

