/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;

public class Strings {
    public static boolean isIndentChar(char c) {
        return Character.isWhitespace(c) && !Strings.isLineDelimiterChar(c);
    }

    public static boolean isLowerCase(char c) {
        return Character.toLowerCase(c) == c;
    }

    public static boolean isLineDelimiterChar(char c) {
        return c == '\n' || c == '\r';
    }

    public static String removeNewLine(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf(10, 0);
        while (n2 != -1) {
            stringBuffer.append(string.substring(n, n2));
            if (n < n2 && n2 != 0) {
                stringBuffer.append(' ');
            }
            n = n2 + 1;
            n2 = string.indexOf(10, n);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String[] convertIntoLines(String string) {
        try {
            DefaultLineTracker defaultLineTracker = new DefaultLineTracker();
            defaultLineTracker.set(string);
            int n = defaultLineTracker.getNumberOfLines();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                IRegion iRegion = defaultLineTracker.getLineInformation(n2);
                int n3 = iRegion.getOffset();
                stringArray[n2] = string.substring(n3, n3 + iRegion.getLength());
                ++n2;
            }
            return stringArray;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static boolean containsOnlyWhitespaces(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String trimLeadingTabsAndSpaces(String string) {
        int n;
        int n2 = n = string.length();
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (!Strings.isIndentChar(c)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == 0) {
            return string;
        }
        if (n2 == n) {
            return "";
        }
        return string.substring(n2);
    }

    public static String trimTrailingTabsAndSpaces(String string) {
        int n;
        int n2 = n = string.length();
        int n3 = n - 1;
        while (n3 >= 0) {
            char c = string.charAt(n3);
            if (!Strings.isIndentChar(c)) break;
            n2 = n3--;
        }
        if (n2 == n) {
            return string;
        }
        if (n2 == 0) {
            return "";
        }
        return string.substring(0, n2);
    }

    public static int computeIndent(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        while (n5 < n4) {
            char c = string.charAt(n5);
            if (c == '\t') {
                ++n2;
                n3 = 0;
            } else if (Strings.isIndentChar(c)) {
                if (++n3 == n) {
                    ++n2;
                    n3 = 0;
                }
            } else {
                return n2;
            }
            ++n5;
        }
        return n2;
    }

    public static String trimIndent(String string, int n, int n2) {
        if (string == null || n <= 0) {
            return string;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = string.length();
        int n7 = 0;
        while (n7 < n6) {
            char c = string.charAt(n7);
            if (c == '\t') {
                ++n4;
                n5 = 0;
            } else if (Strings.isIndentChar(c)) {
                if (++n5 == n2) {
                    ++n4;
                    n5 = 0;
                }
            } else {
                n3 = n7 + 1;
                break;
            }
            if (n4 == n) {
                n3 = n7 + 1;
                break;
            }
            ++n7;
        }
        if (n3 == n6) {
            return "";
        }
        return string.substring(n3);
    }

    public static String trimIndents(String string, int n) {
        int n2 = Strings.computeIndent(string, n);
        if (n2 == 0) {
            return string;
        }
        return Strings.trimIndent(string, n2, n);
    }

    public static void trimIndentation(String[] stringArray, int n) {
        Strings.trimIndentation(stringArray, n, true);
    }

    public static void trimIndentation(String[] stringArray, int n, boolean bl) {
        String string;
        String[] stringArray2 = new String[stringArray.length];
        int n2 = Integer.MAX_VALUE;
        int n3 = bl ? 0 : 1;
        while (n3 < stringArray.length) {
            string = stringArray[n3];
            if (!Strings.containsOnlyWhitespaces(string)) {
                stringArray2[n3] = string;
                int n4 = Strings.computeIndent(string, n);
                if (n4 < n2) {
                    n2 = n4;
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            n3 = bl ? 0 : 1;
            while (n3 < stringArray2.length) {
                String string2;
                int n5;
                string = stringArray2[n3];
                stringArray[n3] = string != null ? Strings.trimIndent(string, n2, n) : ((n5 = Strings.computeIndent(string2 = stringArray[n3], n)) > n2 ? Strings.trimIndent(string2, n2, n) : Strings.trimLeadingTabsAndSpaces(string2));
                ++n3;
            }
        }
    }

    public static String getIndentString(String string, int n) {
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            char c = string.charAt(n5);
            if (c == '\t') {
                n3 = n5 + 1;
                n4 = 0;
            } else {
                if (!Strings.isIndentChar(c)) break;
                if (++n4 == n) {
                    n3 = n5 + 1;
                    n4 = 0;
                }
            }
            ++n5;
        }
        if (n3 == 0) {
            return "";
        }
        if (n3 == n2) {
            return string;
        }
        return string.substring(0, n3);
    }

    public static String[] removeTrailingEmptyLines(String[] stringArray) {
        int n = Strings.findLastNonEmptyLineIndex(stringArray);
        String[] stringArray2 = new String[n + 1];
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringArray2[n2] = stringArray[n2];
            ++n2;
        }
        return stringArray2;
    }

    private static int findLastNonEmptyLineIndex(String[] stringArray) {
        int n = stringArray.length - 1;
        while (n >= 0) {
            if (!stringArray[n].trim().equals("")) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public static String changeIndent(String string, int n, int n2, String string2, String string3) {
        try {
            DefaultLineTracker defaultLineTracker = new DefaultLineTracker();
            defaultLineTracker.set(string);
            int n3 = defaultLineTracker.getNumberOfLines();
            if (n3 == 1) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            while (n4 < n3) {
                IRegion iRegion = defaultLineTracker.getLineInformation(n4);
                int n5 = iRegion.getOffset();
                int n6 = n5 + iRegion.getLength();
                String string4 = string.substring(n5, n6);
                if (n4 == 0) {
                    stringBuffer.append(string4);
                } else {
                    stringBuffer.append(string3);
                    stringBuffer.append(string2);
                    stringBuffer.append(Strings.trimIndent(string4, n, n2));
                }
                ++n4;
            }
            return stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {
            return string;
        }
    }

    public static String concatenate(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean equals(String string, char[] cArray) {
        if (string.length() != cArray.length) {
            return false;
        }
        int n = cArray.length;
        while (--n >= 0) {
            if (string.charAt(n) == cArray[n]) continue;
            return false;
        }
        return true;
    }
}

