/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.io.File;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.internal.ui.GDBDebuggerPage;
import org.eclipse.cdt.debug.mi.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.mi.internal.ui.SerialPortSettingsBlock;
import org.eclipse.cdt.debug.mi.internal.ui.TCPSettingsBlock;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.ComboDialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class GDBServerDebuggerPage
extends GDBDebuggerPage {
    private static final String CONNECTION_TCP = "TCP";
    private static final String CONNECTION_SERIAL = "Serial";
    private ComboDialogField fConnectionField;
    private String[] fConnections = new String[]{"TCP", "Serial"};
    private TCPSettingsBlock fTCPBlock;
    private SerialPortSettingsBlock fSerialBlock;
    private Composite fConnectionStack;

    public GDBServerDebuggerPage() {
        this.fConnectionField = this.createConnectionField();
        this.fTCPBlock = new TCPSettingsBlock();
        this.fSerialBlock = new SerialPortSettingsBlock();
        this.fTCPBlock.addObserver(this);
        this.fSerialBlock.addObserver(this);
    }

    public void createMainTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Main");
        Composite composite = ControlFactory.createCompositeEx((Composite)this.fTabFolder, (int)1, (int)1808);
        ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = false;
        tabItem.setControl((Control)composite);
        Composite composite2 = ControlFactory.createCompositeEx((Composite)composite, (int)3, (int)768);
        ((GridLayout)composite2.getLayout()).makeColumnsEqualWidth = false;
        Label label = ControlFactory.createLabel((Composite)composite2, (String)"GDB debugger:");
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.fGDBCommandText = ControlFactory.createTextField((Composite)composite2, (int)2052);
        this.fGDBCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        Button button = this.createPushButton(composite2, "&Browse...", null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.handleGDBButtonSelected();
                GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBButtonSelected() {
                String string;
                FileDialog fileDialog = new FileDialog(GDBServerDebuggerPage.this.getShell(), 0);
                fileDialog.setText("GDB Command File");
                String string2 = GDBServerDebuggerPage.this.fGDBCommandText.getText().trim();
                int n = string2.lastIndexOf(File.separator);
                if (n != -1) {
                    fileDialog.setFilterPath(string2.substring(0, n));
                }
                if ((string = fileDialog.open()) == null) {
                    return;
                }
                GDBServerDebuggerPage.this.fGDBCommandText.setText(string);
            }
        });
        label = ControlFactory.createLabel((Composite)composite2, (String)"GDB command file:");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.fGDBInitText = ControlFactory.createTextField((Composite)composite2, (int)2052);
        gridData = new GridData(768);
        this.fGDBInitText.setLayoutData((Object)gridData);
        this.fGDBInitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        button = this.createPushButton(composite2, "&Browse...", null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.handleGDBInitButtonSelected();
                GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBInitButtonSelected() {
                String string;
                FileDialog fileDialog = new FileDialog(GDBServerDebuggerPage.this.getShell(), 0);
                fileDialog.setText("GDB command file");
                String string2 = GDBServerDebuggerPage.this.fGDBInitText.getText().trim();
                int n = string2.lastIndexOf(File.separator);
                if (n != -1) {
                    fileDialog.setFilterPath(string2.substring(0, n));
                }
                if ((string = fileDialog.open()) == null) {
                    return;
                }
                GDBServerDebuggerPage.this.fGDBInitText.setText(string);
            }
        });
        this.extendMainTab(composite);
    }

    protected void extendMainTab(Composite composite) {
        Composite composite2 = ControlFactory.createCompositeEx((Composite)composite, (int)2, (int)1808);
        ((GridLayout)composite2.getLayout()).makeColumnsEqualWidth = false;
        this.fConnectionField.doFillIntoGrid(composite2, 2);
        ((GridData)this.fConnectionField.getComboControl(null).getLayoutData()).horizontalAlignment = 1;
        PixelConverter pixelConverter = new PixelConverter((Control)composite2);
        LayoutUtil.setWidthHint((Control)this.fConnectionField.getComboControl(null), pixelConverter.convertWidthInCharsToPixels(15));
        this.fConnectionStack = ControlFactory.createCompositeEx((Composite)composite2, (int)1, (int)1808);
        StackLayout stackLayout = new StackLayout();
        this.fConnectionStack.setLayout((Layout)stackLayout);
        ((GridData)this.fConnectionStack.getLayoutData()).horizontalSpan = 2;
        this.fTCPBlock.createBlock(this.fConnectionStack);
        this.fSerialBlock.createBlock(this.fConnectionStack);
        this.connectionTypeChanged();
    }

    private ComboDialogField createConnectionField() {
        ComboDialogField comboDialogField = new ComboDialogField(12);
        comboDialogField.setLabelText("Connection: ");
        comboDialogField.setItems(this.fConnections);
        comboDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                GDBServerDebuggerPage.this.connectionTypeChanged();
            }
        });
        return comboDialogField;
    }

    protected void connectionTypeChanged() {
        ((StackLayout)this.fConnectionStack.getLayout()).topControl = null;
        int n = this.fConnectionField.getSelectionIndex();
        if (n >= 0 && n < this.fConnections.length) {
            String[] stringArray = this.fConnectionField.getItems();
            if (CONNECTION_TCP.equals(stringArray[n])) {
                ((StackLayout)this.fConnectionStack.getLayout()).topControl = this.fTCPBlock.getControl();
            } else if (CONNECTION_SERIAL.equals(stringArray[n])) {
                ((StackLayout)this.fConnectionStack.getLayout()).topControl = this.fSerialBlock.getControl();
            }
        }
        this.fConnectionStack.layout();
        this.updateLaunchConfigurationDialog();
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        if (super.isValid(iLaunchConfiguration)) {
            this.setErrorMessage(null);
            this.setMessage(null);
            int n = this.fConnectionField.getSelectionIndex();
            if (n >= 0 && n < this.fConnections.length) {
                String[] stringArray = this.fConnectionField.getItems();
                if (CONNECTION_TCP.equals(stringArray[n])) {
                    if (!this.fTCPBlock.isValid(iLaunchConfiguration)) {
                        this.setErrorMessage(this.fTCPBlock.getErrorMessage());
                        return false;
                    }
                } else if (CONNECTION_SERIAL.equals(stringArray[n]) && !this.fSerialBlock.isValid(iLaunchConfiguration)) {
                    this.setErrorMessage(this.fSerialBlock.getErrorMessage());
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        super.initializeFrom(iLaunchConfiguration);
        boolean bl = false;
        try {
            bl = iLaunchConfiguration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, false);
        }
        catch (CoreException coreException) {}
        this.fTCPBlock.initializeFrom(iLaunchConfiguration);
        this.fSerialBlock.initializeFrom(iLaunchConfiguration);
        this.fConnectionField.selectItem(bl ? 0 : 1);
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        super.performApply(iLaunchConfigurationWorkingCopy);
        if (this.fConnectionField != null) {
            iLaunchConfigurationWorkingCopy.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, this.fConnectionField.getSelectionIndex() == 0);
        }
        this.fTCPBlock.performApply(iLaunchConfigurationWorkingCopy);
        this.fSerialBlock.performApply(iLaunchConfigurationWorkingCopy);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        super.setDefaults(iLaunchConfigurationWorkingCopy);
        iLaunchConfigurationWorkingCopy.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, false);
        this.fTCPBlock.setDefaults(iLaunchConfigurationWorkingCopy);
        this.fSerialBlock.setDefaults(iLaunchConfigurationWorkingCopy);
    }
}

