/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.dialogfields;

import org.eclipse.cdt.debug.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class DialogField {
    private Label fLabel = null;
    protected String fLabelText = "";
    private IDialogFieldListener fDialogFieldListener;
    private boolean fEnabled = true;

    public void setLabelText(String string) {
        this.fLabelText = string;
    }

    public final void setDialogFieldListener(IDialogFieldListener iDialogFieldListener) {
        this.fDialogFieldListener = iDialogFieldListener;
    }

    public void dialogFieldChanged() {
        if (this.fDialogFieldListener != null) {
            this.fDialogFieldListener.dialogFieldChanged(this);
        }
    }

    public boolean setFocus() {
        return false;
    }

    public void postSetFocusOnDialogField(Display display) {
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    DialogField.this.setFocus();
                }
            });
        }
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        label.setLayoutData((Object)DialogField.gridDataForLabel(n));
        return new Control[]{label};
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected static GridData gridDataForLabel(int n) {
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = n;
        return gridData;
    }

    public Label getLabelControl(Composite composite) {
        if (this.fLabel == null) {
            this.assertCompositeNotNull(composite);
            this.fLabel = new Label(composite, 16448);
            this.fLabel.setFont(composite.getFont());
            this.fLabel.setEnabled(this.fEnabled);
            if (this.fLabelText != null && !"".equals(this.fLabelText)) {
                this.fLabel.setText(this.fLabelText);
            } else {
                this.fLabel.setText(".");
                this.fLabel.setVisible(false);
            }
        }
        return this.fLabel;
    }

    public static Control createEmptySpace(Composite composite) {
        return DialogField.createEmptySpace(composite, 1);
    }

    public static Control createEmptySpace(Composite composite, int n) {
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = n;
        gridData.horizontalIndent = 0;
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected final boolean isOkToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public final void setEnabled(boolean bl) {
        if (bl != this.fEnabled) {
            this.fEnabled = bl;
            this.updateEnableState();
        }
    }

    protected void updateEnableState() {
        if (this.fLabel != null) {
            this.fLabel.setEnabled(this.fEnabled);
        }
    }

    public final boolean isEnabled() {
        return this.fEnabled;
    }

    protected final void assertCompositeNotNull(Composite composite) {
        Assert.isNotNull((Object)composite, (String)"uncreated control requested with composite null");
    }

    protected final void assertEnoughColumns(int n) {
        Assert.isTrue((n >= this.getNumberOfControls() ? 1 : 0) != 0, (String)"given number of columns is too small");
    }
}

