/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CDirectorySourceLocation;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.ListDialogField;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceLookupLabelProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SourceListDialogField
extends ListDialogField {
    protected static final String YES_VALUE = CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceListDialogField.yes");
    protected static final String NO_VALUE = CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceListDialogField.no");
    private static final String CP_LOCATION = "location";
    private static final String CP_ASSOCIATION = "association";
    private static final String CP_SEARCH_SUBFOLDERS = "searchSubfolders";
    private ObservableSourceList fObservable;

    public SourceListDialogField(String string, IListAdapter iListAdapter) {
        String[] stringArray = new String[6];
        stringArray[0] = CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceListDialogField.Add");
        stringArray[2] = CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceListDialogField.Up");
        stringArray[3] = CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceListDialogField.Down");
        stringArray[5] = CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceListDialogField.Remove");
        super(iListAdapter, stringArray, (ILabelProvider)new SourceLookupLabelProvider());
        this.fObservable = new ObservableSourceList();
        this.setUpButtonIndex(2);
        this.setDownButtonIndex(3);
        this.setRemoveButtonIndex(5);
        this.setLabelText(string);
    }

    protected boolean managedButtonPressed(int n) {
        super.managedButtonPressed(n);
        return false;
    }

    protected TableViewer createTableViewer(Composite composite) {
        TableViewer tableViewer = super.createTableViewer(composite);
        Table table = tableViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        new TableColumn(table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, true));
        new TableColumn(table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, true));
        new TableColumn(table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        TableColumn[] tableColumnArray = table.getColumns();
        tableColumnArray[0].setText(CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceListDialogField.Location"));
        tableColumnArray[1].setText(CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceListDialogField.Association"));
        tableColumnArray[2].setText(CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceListDialogField.Search_subfolders"));
        TextCellEditor textCellEditor = new TextCellEditor((Composite)table);
        ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor((Composite)table, new String[]{YES_VALUE, NO_VALUE});
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = textCellEditor;
        cellEditorArray[2] = comboBoxCellEditor;
        tableViewer.setCellEditors(cellEditorArray);
        tableViewer.setColumnProperties(new String[]{CP_LOCATION, CP_ASSOCIATION, CP_SEARCH_SUBFOLDERS});
        tableViewer.setCellModifier(this.createCellModifier());
        return tableViewer;
    }

    private ICellModifier createCellModifier() {
        return new ICellModifier(){

            public boolean canModify(Object object, String string) {
                return object instanceof CDirectorySourceLocation && (string.equals(SourceListDialogField.CP_ASSOCIATION) || string.equals(SourceListDialogField.CP_SEARCH_SUBFOLDERS));
            }

            public Object getValue(Object object, String string) {
                if (object instanceof CDirectorySourceLocation && string.equals(SourceListDialogField.CP_ASSOCIATION)) {
                    return ((CDirectorySourceLocation)object).getAssociation() != null ? ((CDirectorySourceLocation)object).getAssociation().toOSString() : "";
                }
                if (object instanceof CDirectorySourceLocation && string.equals(SourceListDialogField.CP_SEARCH_SUBFOLDERS)) {
                    return ((CDirectorySourceLocation)object).searchSubfolders() ? new Integer(0) : new Integer(1);
                }
                return null;
            }

            public void modify(Object object, String string, Object object2) {
                Object object3 = SourceListDialogField.this.getSelection();
                if (object3 instanceof CDirectorySourceLocation) {
                    Path path;
                    if (string.equals(SourceListDialogField.CP_ASSOCIATION) && object2 instanceof String && (path = new Path((String)object2)).isValidPath((String)object2)) {
                        ((CDirectorySourceLocation)object3).setAssociation((IPath)path);
                        SourceListDialogField.this.setChanged();
                    }
                    if (string.equals(SourceListDialogField.CP_SEARCH_SUBFOLDERS) && object2 instanceof Integer) {
                        ((CDirectorySourceLocation)object3).setSearchSubfolders((Integer)object2 == 0);
                        SourceListDialogField.this.setChanged();
                    }
                    if (SourceListDialogField.this.hasChanged()) {
                        SourceListDialogField.this.refresh();
                        SourceListDialogField.this.notifyObservers();
                    }
                }
            }
        };
    }

    protected Object getSelection() {
        List list = this.getSelectedElements();
        return list.size() > 0 ? list.get(0) : null;
    }

    public synchronized void addObserver(Observer observer) {
        this.fObservable.addObserver(observer);
    }

    public synchronized void deleteObserver(Observer observer) {
        this.fObservable.deleteObserver(observer);
    }

    public synchronized boolean hasChanged() {
        return this.fObservable.hasChanged();
    }

    public void notifyObservers() {
        this.fObservable.notifyObservers();
    }

    public void notifyObservers(Object object) {
        this.fObservable.notifyObservers(object);
    }

    public void dispose() {
    }

    protected void setChanged() {
        this.fObservable.setChanged();
    }

    public ICSourceLocation[] getSourceLocations() {
        List list = this.getElements();
        return list.toArray(new ICSourceLocation[list.size()]);
    }

    public class ObservableSourceList
    extends Observable {
        protected synchronized void setChanged() {
            super.setChanged();
        }
    }
}

