/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.core.resources.IResource;

class CElementInfo {
    protected CElement element;
    protected ICElement[] fChildren;
    protected static ICElement[] fgEmptyChildren = new ICElement[0];
    protected boolean fIsStructureKnown = false;
    protected long modificationStamp = 0L;

    protected CElementInfo(CElement cElement) {
        this.element = cElement;
        this.fChildren = fgEmptyChildren;
    }

    protected CElement getElement() {
        return this.element;
    }

    protected void addChild(ICElement iCElement) {
        if (this.fChildren == fgEmptyChildren) {
            this.setChildren(new ICElement[]{iCElement});
        } else if (!this.includesChild(iCElement)) {
            this.setChildren(this.growAndAddToArray(this.fChildren, iCElement));
        }
    }

    protected ICElement[] getChildren() {
        return this.fChildren;
    }

    protected ICElement[] growAndAddToArray(ICElement[] iCElementArray, ICElement iCElement) {
        ICElement[] iCElementArray2 = iCElementArray;
        iCElementArray = new ICElement[iCElementArray2.length + 1];
        System.arraycopy(iCElementArray2, 0, iCElementArray, 0, iCElementArray2.length);
        iCElementArray[iCElementArray2.length] = iCElement;
        return iCElementArray;
    }

    protected boolean includesChild(ICElement iCElement) {
        int n = 0;
        while (n < this.fChildren.length) {
            if (this.fChildren[n].equals(iCElement)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isStructureKnown() {
        return this.fIsStructureKnown;
    }

    protected ICElement[] removeAndShrinkArray(ICElement[] iCElementArray, ICElement iCElement) {
        ICElement[] iCElementArray2 = iCElementArray;
        iCElementArray = new ICElement[iCElementArray2.length - 1];
        int n = 0;
        int n2 = 0;
        while (n2 < iCElementArray2.length) {
            if (iCElementArray2[n2].equals(iCElement)) {
                System.arraycopy(iCElementArray2, n2 + 1, iCElementArray, n, iCElementArray2.length - (n2 + 1));
                return iCElementArray;
            }
            iCElementArray[n] = iCElementArray2[n2];
            ++n;
            ++n2;
        }
        return iCElementArray;
    }

    protected void removeChild(ICElement iCElement) {
        if (this.includesChild(iCElement)) {
            this.setChildren(this.removeAndShrinkArray(this.fChildren, iCElement));
        }
    }

    protected void removeChildren() {
        this.fChildren = fgEmptyChildren;
    }

    protected void setChildren(ICElement[] iCElementArray) {
        this.fChildren = iCElementArray;
    }

    protected boolean hasChildren() {
        return this.fChildren.length > 0;
    }

    protected void setChanged() {
        this.modificationStamp = 0L;
    }

    protected boolean hasChanged() {
        IResource iResource = null;
        boolean bl = false;
        iResource = this.getElement().getUnderlyingResource();
        if (iResource != null && iResource.exists()) {
            long l = 0L;
            switch (iResource.getType()) {
                case 2: 
                case 4: 
                case 8: {
                    File file = iResource.getLocation().toFile();
                    l = file.lastModified();
                    break;
                }
                case 1: {
                    l = iResource.getModificationStamp();
                }
            }
            bl = l != this.modificationStamp;
            this.modificationStamp = l;
        }
        return bl;
    }

    protected void setIsStructureKnown(boolean bl) {
        this.fIsStructureKnown = bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }
}

