/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CommitWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.TranslationUnitInfo;
import org.eclipse.cdt.internal.core.model.WorkingCopyInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkingCopy
extends TranslationUnit
implements IWorkingCopy {
    protected IBufferFactory bufferFactory;
    protected int useCount = 1;

    public WorkingCopy(ICElement iCElement, IFile iFile, IBufferFactory iBufferFactory) {
        super(iCElement, iFile);
        this.bufferFactory = iBufferFactory == null ? this.getBufferManager() : iBufferFactory;
    }

    public WorkingCopy(ICElement iCElement, IPath iPath, IBufferFactory iBufferFactory) {
        super(iCElement, iPath);
        this.bufferFactory = iBufferFactory == null ? this.getBufferManager() : iBufferFactory;
    }

    public void commit(boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        ITranslationUnit iTranslationUnit = this.getOriginalElement();
        if (iTranslationUnit.exists()) {
            CommitWorkingCopyOperation commitWorkingCopyOperation = new CommitWorkingCopyOperation(this, bl);
            this.runOperation(commitWorkingCopyOperation, iProgressMonitor);
        } else {
            String string = this.getSource();
            if (string == null) {
                return;
            }
            try {
                byte[] byArray = string.getBytes();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                IFile iFile = (IFile)iTranslationUnit.getResource();
                if (iFile.exists()) {
                    iFile.setContents((InputStream)byteArrayInputStream, bl ? 3 : 2, null);
                } else {
                    iFile.create((InputStream)byteArrayInputStream, bl, iProgressMonitor);
                }
            }
            catch (CoreException coreException) {
                throw new CModelException(coreException);
            }
        }
    }

    protected CElementInfo createElementInfo() {
        return new WorkingCopyInfo(this);
    }

    public void destroy() {
        if (--this.useCount > 0) {
            return;
        }
        try {
            this.close();
            ITranslationUnit iTranslationUnit = this.getOriginalElement();
            if (!this.getParent().exists()) {
                ((TranslationUnit)iTranslationUnit).close();
            }
            CModelManager cModelManager = CModelManager.getDefault();
            Map map = cModelManager.sharedWorkingCopies;
            Map map2 = (Map)map.get(this.bufferFactory);
            if (map2 != null) {
                map2.remove(iTranslationUnit);
            }
        }
        catch (CModelException cModelException) {}
    }

    public boolean exists() {
        return this.useCount != 0;
    }

    public IBufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public ITranslationUnit getOriginalElement() {
        return new TranslationUnit(this.getParent(), this.getFile());
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor iProgressMonitor, IBufferFactory iBufferFactory) throws CModelException {
        return this;
    }

    public IWorkingCopy getWorkingCopy() {
        return this;
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor iProgressMonitor, IBufferFactory iBufferFactory) {
        return this;
    }

    public boolean isBasedOn(IResource iResource) {
        if (iResource.getType() != 1) {
            return false;
        }
        if (this.useCount == 0) {
            return false;
        }
        return ((TranslationUnitInfo)this.getElementInfo()).fTimestamp == ((IFile)iResource).getModificationStamp();
    }

    public boolean isWorkingCopy() {
        return true;
    }

    public void open(IProgressMonitor iProgressMonitor) throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        super.open(iProgressMonitor);
    }

    protected IBuffer openBuffer(IProgressMonitor iProgressMonitor) throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        IBuffer iBuffer = this.getBufferFactory().createBuffer(this);
        if (iBuffer == null) {
            return null;
        }
        if (iBuffer.getCharacters() == null) {
            IBuffer iBuffer2;
            block8: {
                ITranslationUnit iTranslationUnit = this.getOriginalElement();
                iBuffer2 = null;
                try {
                    iBuffer2 = iTranslationUnit.getBuffer();
                }
                catch (CModelException cModelException) {
                    if (cModelException.getCModelStatus().doesNotExist()) break block8;
                    throw cModelException;
                }
            }
            if (iBuffer2 != null) {
                char[] cArray = iBuffer2.getCharacters();
                if (cArray != null) {
                    iBuffer.setContents((char[])cArray.clone());
                }
            } else {
                iBuffer.setContents(new char[0]);
            }
        }
        this.getBufferManager().addBuffer(iBuffer);
        iBuffer.addBufferChangedListener(this);
        return iBuffer;
    }

    public IMarker[] reconcile() throws CModelException {
        this.reconcile(false, null);
        return null;
    }

    /*
     * Exception decompiling
     */
    public boolean reconcile(boolean var1_1, IProgressMonitor var2_2) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 180->183)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void restore() throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        TranslationUnit translationUnit = (TranslationUnit)this.getOriginalElement();
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer == null) {
            return;
        }
        iBuffer.setContents(translationUnit.getContents());
        this.updateTimeStamp(translationUnit);
        this.makeConsistent(null);
    }

    public void save(IProgressMonitor iProgressMonitor, boolean bl) throws CModelException {
        if (this.isReadOnly()) {
            throw new CModelException(new CModelStatus(976, this));
        }
        this.reconcile();
    }

    protected void updateTimeStamp(TranslationUnit translationUnit) throws CModelException {
        long l = ((IFile)translationUnit.getResource()).getModificationStamp();
        if (l == -1L) {
            throw new CModelException(new CModelStatus(995));
        }
        ((TranslationUnitInfo)this.getElementInfo()).fTimestamp = l;
    }
}

