/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.IIndexer;
import org.eclipse.cdt.internal.core.index.IIndexerOutput;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.core.resources.IFile;

public abstract class AbstractIndexer
implements IIndexer,
IIndexConstants,
ICSearchConstants {
    IIndexerOutput output;
    static final int CLASS = 1;
    static final int STRUCT = 2;
    static final int UNION = 3;
    static final int ENUM = 4;
    static final int VAR = 5;
    static final int TYPEDEF = 6;
    public static boolean VERBOSE = false;

    public static void verbose(String string) {
        System.out.println("(" + Thread.currentThread() + ") " + string);
    }

    public void addClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
        if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.CLASS)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(iASTClassSpecifier.getFullyQualifiedName(), 1, ICSearchConstants.DECLARATIONS));
        } else if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.STRUCT)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(iASTClassSpecifier.getFullyQualifiedName(), 2, ICSearchConstants.DECLARATIONS));
        } else if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.UNION)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(iASTClassSpecifier.getFullyQualifiedName(), 3, ICSearchConstants.DECLARATIONS));
        }
    }

    public void addEnumerationSpecifier(IASTEnumerationSpecifier iASTEnumerationSpecifier) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(iASTEnumerationSpecifier.getFullyQualifiedName(), 4, ICSearchConstants.DECLARATIONS));
        Iterator iterator = iASTEnumerationSpecifier.getEnumerators();
        while (iterator.hasNext()) {
            IASTEnumerator iASTEnumerator = (IASTEnumerator)iterator.next();
            String[] stringArray = this.createEnumeratorFullyQualifiedName(iASTEnumerator);
            this.output.addRef(AbstractIndexer.encodeEntry(stringArray, IIndexConstants.FIELD_DECL, 10));
        }
    }

    protected String[] createEnumeratorFullyQualifiedName(IASTEnumerator iASTEnumerator) {
        String string = iASTEnumerator.getName();
        IASTEnumerationSpecifier iASTEnumerationSpecifier = iASTEnumerator.getOwnerEnumerationSpecifier();
        String[] stringArray = iASTEnumerationSpecifier.getFullyQualifiedName();
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length - 1] = string;
        return stringArray2;
    }

    public void addEnumeratorReference(IASTEnumerator iASTEnumerator) {
        this.output.addRef(AbstractIndexer.encodeEntry(this.createEnumeratorFullyQualifiedName(iASTEnumerator), IIndexConstants.FIELD_REF, 9));
    }

    public void addMacro(IASTMacro iASTMacro) {
        String[] stringArray = new String[]{iASTMacro.getName()};
        this.output.addRef(AbstractIndexer.encodeEntry(stringArray, IIndexConstants.MACRO_DECL, 10));
    }

    public void addEnumerationReference(IASTEnumerationSpecifier iASTEnumerationSpecifier) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(iASTEnumerationSpecifier.getFullyQualifiedName(), 4, ICSearchConstants.REFERENCES));
    }

    public void addVariable(IASTVariable iASTVariable) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(iASTVariable.getFullyQualifiedName(), 5, ICSearchConstants.DECLARATIONS));
    }

    public void addVariableReference(IASTVariable iASTVariable) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(iASTVariable.getFullyQualifiedName(), 5, ICSearchConstants.REFERENCES));
    }

    public void addParameterReference(IASTParameterDeclaration iASTParameterDeclaration) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(new String[]{iASTParameterDeclaration.getName()}, 5, ICSearchConstants.REFERENCES));
    }

    public void addTypedefDeclaration(IASTTypedefDeclaration iASTTypedefDeclaration) {
        this.output.addRef(AbstractIndexer.encodeEntry(iASTTypedefDeclaration.getFullyQualifiedName(), IIndexConstants.TYPEDEF_DECL, 11));
    }

    public void addFieldDeclaration(IASTField iASTField) {
        this.output.addRef(AbstractIndexer.encodeEntry(iASTField.getFullyQualifiedName(), IIndexConstants.FIELD_DECL, 10));
    }

    public void addFieldReference(IASTField iASTField) {
        this.output.addRef(AbstractIndexer.encodeEntry(iASTField.getFullyQualifiedName(), IIndexConstants.FIELD_REF, 9));
    }

    public void addMethodDeclaration(IASTMethod iASTMethod) {
        this.output.addRef(AbstractIndexer.encodeEntry(iASTMethod.getFullyQualifiedName(), IIndexConstants.METHOD_DECL, 11));
    }

    public void addMethodReference(IASTMethod iASTMethod) {
        this.output.addRef(AbstractIndexer.encodeEntry(iASTMethod.getFullyQualifiedName(), IIndexConstants.METHOD_REF, 10));
    }

    public void addElaboratedForwardDeclaration(IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier) {
        if (iASTElaboratedTypeSpecifier.getClassKind().equals(ASTClassKind.CLASS)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(iASTElaboratedTypeSpecifier.getFullyQualifiedName(), 1, ICSearchConstants.DECLARATIONS));
        } else if (iASTElaboratedTypeSpecifier.getClassKind().equals(ASTClassKind.STRUCT)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(iASTElaboratedTypeSpecifier.getFullyQualifiedName(), 2, ICSearchConstants.DECLARATIONS));
        } else if (iASTElaboratedTypeSpecifier.getClassKind().equals(ASTClassKind.UNION)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(iASTElaboratedTypeSpecifier.getFullyQualifiedName(), 3, ICSearchConstants.DECLARATIONS));
        }
    }

    public void addConstructorDeclaration() {
    }

    public void addConstructorReference() {
    }

    public void addMemberDeclaration() {
    }

    public void addMemberReference() {
    }

    public void addFunctionDeclaration(IASTFunction iASTFunction) {
        this.output.addRef(AbstractIndexer.encodeEntry(iASTFunction.getFullyQualifiedName(), IIndexConstants.FUNCTION_DECL, 13));
    }

    public void addFunctionReference(IASTFunction iASTFunction) {
        this.output.addRef(AbstractIndexer.encodeEntry(iASTFunction.getFullyQualifiedName(), IIndexConstants.FUNCTION_REF, 12));
    }

    public void addNameReference() {
    }

    public void addNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
        this.output.addRef(AbstractIndexer.encodeEntry(iASTNamespaceDefinition.getFullyQualifiedName(), IIndexConstants.NAMESPACE_DECL, 14));
    }

    public void addNamespaceReference(IASTNamespaceDefinition iASTNamespaceDefinition) {
        this.output.addRef(AbstractIndexer.encodeEntry(iASTNamespaceDefinition.getFullyQualifiedName(), IIndexConstants.NAMESPACE_REF, 13));
    }

    public void addTypedefReference(IASTTypedefDeclaration iASTTypedefDeclaration) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(iASTTypedefDeclaration.getFullyQualifiedName(), 6, ICSearchConstants.REFERENCES));
    }

    private void addSuperTypeReference(int n, char[] cArray, char[] cArray2, char[][] cArray3, char c, char[] cArray4, char c2) {
    }

    public void addTypeReference(char[] cArray) {
    }

    public void addClassReference(IASTTypeSpecifier iASTTypeSpecifier) {
        String[] stringArray = null;
        Object object = null;
        if (iASTTypeSpecifier instanceof IASTClassSpecifier) {
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTypeSpecifier;
            stringArray = iASTClassSpecifier.getFullyQualifiedName();
            object = iASTClassSpecifier.getClassKind();
        } else if (iASTTypeSpecifier instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTTypeSpecifier;
            stringArray = iASTElaboratedTypeSpecifier.getFullyQualifiedName();
            object = iASTElaboratedTypeSpecifier.getClassKind();
        }
        if (object.equals(ASTClassKind.CLASS)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(stringArray, 1, ICSearchConstants.REFERENCES));
        } else if (object.equals(ASTClassKind.STRUCT)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(stringArray, 2, ICSearchConstants.REFERENCES));
        } else if (object.equals(ASTClassKind.UNION)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(stringArray, 3, ICSearchConstants.REFERENCES));
        }
    }

    protected static final char[] encodeTypeEntry(String[] stringArray, int n, ICSearchConstants.LimitTo limitTo) {
        Object object;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            object = stringArray[n4];
            n3 += ((String)object).length();
            ++n4;
        }
        char[] cArray = null;
        if (limitTo == ICSearchConstants.REFERENCES) {
            cArray = new char[8 + n3 + stringArray.length + 1];
            n2 = 8;
            System.arraycopy(IIndexConstants.TYPE_REF, 0, cArray, 0, 8);
        } else if (limitTo == ICSearchConstants.DECLARATIONS) {
            cArray = new char[9 + n3 + stringArray.length + 1];
            n2 = 9;
            System.arraycopy(IIndexConstants.TYPE_DECL, 0, cArray, 0, 9);
        }
        switch (n) {
            case 1: {
                cArray[n2++] = 67;
                break;
            }
            case 2: {
                cArray[n2++] = 83;
                break;
            }
            case 3: {
                cArray[n2++] = 85;
                break;
            }
            case 4: {
                cArray[n2++] = 69;
                break;
            }
            case 5: {
                cArray[n2++] = 86;
                break;
            }
            case 6: {
                cArray[n2++] = 84;
            }
        }
        cArray[n2++] = 47;
        if (stringArray.length > 0) {
            object = stringArray[stringArray.length - 1].toCharArray();
            System.arraycopy(object, 0, cArray, n2, ((Object)object).length);
            n2 += ((Object)object).length;
        }
        int n5 = stringArray.length - 2;
        while (n5 >= 0) {
            cArray[n2++] = 47;
            char[] cArray2 = stringArray[n5].toCharArray();
            System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
            n2 += cArray2.length;
            --n5;
        }
        if (VERBOSE) {
            AbstractIndexer.verbose(new String(cArray));
        }
        return cArray;
    }

    protected static final char[] encodeEntry(String[] stringArray, char[] cArray, int n) {
        Object object;
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            object = stringArray[n3];
            n2 += ((String)object).length();
            ++n3;
        }
        char[] cArray2 = new char[n + n2 + stringArray.length - 1];
        int n4 = cArray.length;
        System.arraycopy(cArray, 0, cArray2, 0, n4);
        if (stringArray.length > 0) {
            object = stringArray[stringArray.length - 1].toCharArray();
            System.arraycopy(object, 0, cArray2, n4, ((Object)object).length);
            n4 += ((Object)object).length;
        }
        int n5 = stringArray.length - 2;
        while (n5 >= 0) {
            cArray2[n4++] = 47;
            char[] cArray3 = stringArray[n5].toCharArray();
            System.arraycopy(cArray3, 0, cArray2, n4, cArray3.length);
            n4 += cArray3.length;
            --n5;
        }
        if (VERBOSE) {
            AbstractIndexer.verbose(new String(cArray2));
        }
        return cArray2;
    }

    public abstract String[] getFileTypes();

    public abstract IFile getResourceFile();

    public void index(IDocument iDocument, IIndexerOutput iIndexerOutput) throws IOException {
        this.output = iIndexerOutput;
        if (this.shouldIndex(iDocument)) {
            this.indexFile(iDocument);
        }
    }

    protected abstract void indexFile(IDocument var1) throws IOException;

    public boolean shouldIndex(IDocument iDocument) {
        String string = iDocument.getType();
        String[] stringArray = this.getFileTypes();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final char[] bestTypePrefix(ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, char[] cArray, char[][] cArray2, int n, boolean bl) {
        char[] cArray3 = null;
        if (limitTo == ICSearchConstants.DECLARATIONS) {
            cArray3 = IIndexConstants.TYPE_DECL;
        } else if (limitTo == ICSearchConstants.REFERENCES) {
            cArray3 = IIndexConstants.TYPE_REF;
        } else {
            return IIndexConstants.TYPE_ALL;
        }
        int n2 = 0;
        if (searchFor == ICSearchConstants.CLASS) {
            n2 = 67;
        } else if (searchFor == ICSearchConstants.STRUCT) {
            n2 = 83;
        } else if (searchFor == ICSearchConstants.UNION) {
            n2 = 85;
        } else if (searchFor == ICSearchConstants.ENUM) {
            n2 = 69;
        } else if (searchFor == ICSearchConstants.TYPEDEF) {
            n2 = 84;
        } else {
            return cArray3;
        }
        return AbstractIndexer.bestPrefix(cArray3, (char)n2, cArray, cArray2, n, bl);
    }

    public static final char[] bestNamespacePrefix(ICSearchConstants.LimitTo limitTo, char[] cArray, char[][] cArray2, int n, boolean bl) {
        char[] cArray3 = null;
        if (limitTo == ICSearchConstants.REFERENCES) {
            cArray3 = IIndexConstants.NAMESPACE_REF;
        } else if (limitTo == ICSearchConstants.DECLARATIONS) {
            cArray3 = IIndexConstants.NAMESPACE_DECL;
        } else {
            return IIndexConstants.NAMESPACE_ALL;
        }
        return AbstractIndexer.bestPrefix(cArray3, '\u0000', cArray, cArray2, n, bl);
    }

    public static final char[] bestVariablePrefix(ICSearchConstants.LimitTo limitTo, char[] cArray, char[][] cArray2, int n, boolean bl) {
        char[] cArray3 = null;
        if (limitTo == ICSearchConstants.REFERENCES) {
            cArray3 = IIndexConstants.TYPE_REF;
        } else if (limitTo == ICSearchConstants.DECLARATIONS) {
            cArray3 = IIndexConstants.TYPE_DECL;
        } else {
            return IIndexConstants.TYPE_ALL;
        }
        return AbstractIndexer.bestPrefix(cArray3, 'V', cArray, cArray2, n, bl);
    }

    public static final char[] bestFieldPrefix(ICSearchConstants.LimitTo limitTo, char[] cArray, char[][] cArray2, int n, boolean bl) {
        char[] cArray3 = null;
        if (limitTo == ICSearchConstants.REFERENCES) {
            cArray3 = IIndexConstants.FIELD_REF;
        } else if (limitTo == ICSearchConstants.DECLARATIONS) {
            cArray3 = IIndexConstants.FIELD_DECL;
        } else {
            return IIndexConstants.FIELD_ALL;
        }
        return AbstractIndexer.bestPrefix(cArray3, '\u0000', cArray, cArray2, n, bl);
    }

    public static final char[] bestMethodPrefix(ICSearchConstants.LimitTo limitTo, char[] cArray, char[][] cArray2, int n, boolean bl) {
        char[] cArray3 = null;
        if (limitTo == ICSearchConstants.REFERENCES) {
            cArray3 = IIndexConstants.METHOD_REF;
        } else if (limitTo == ICSearchConstants.DECLARATIONS) {
            cArray3 = IIndexConstants.METHOD_DECL;
        } else {
            if (limitTo == ICSearchConstants.DEFINITIONS) {
                return IIndexConstants.METHOD_ALL;
            }
            return IIndexConstants.METHOD_ALL;
        }
        return AbstractIndexer.bestPrefix(cArray3, '\u0000', cArray, cArray2, n, bl);
    }

    public static final char[] bestFunctionPrefix(ICSearchConstants.LimitTo limitTo, char[] cArray, int n, boolean bl) {
        char[] cArray2 = null;
        if (limitTo == ICSearchConstants.REFERENCES) {
            cArray2 = IIndexConstants.FUNCTION_REF;
        } else if (limitTo == ICSearchConstants.DECLARATIONS) {
            cArray2 = IIndexConstants.FUNCTION_DECL;
        } else {
            if (limitTo == ICSearchConstants.DEFINITIONS) {
                return IIndexConstants.FUNCTION_ALL;
            }
            return IIndexConstants.FUNCTION_ALL;
        }
        return AbstractIndexer.bestPrefix(cArray2, '\u0000', cArray, null, n, bl);
    }

    public static final char[] bestPrefix(char[] cArray, char c, char[] cArray2, char[][] cArray3, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        char[] cArray4;
        int n5;
        int n6;
        int n7;
        char[] cArray5;
        block22: {
            block21: {
                cArray5 = null;
                n7 = 0;
                n6 = -1;
                n5 = cArray.length;
                if (c != '\u0000') {
                    n5 += 2;
                }
                if (bl) break block21;
                cArray2 = null;
                break block22;
            }
            if (n != 2 || cArray2 == null) break block22;
            cArray4 = new char[cArray2.length];
            n4 = 0;
            int n8 = 0;
            int n9 = 0;
            while (n9 < cArray2.length) {
                block25: {
                    block26: {
                        block23: {
                            block24: {
                                if (cArray2[n9] != '\\') break block23;
                                if (n4 != 0) break block24;
                                n4 = 1;
                                break block25;
                            }
                            n4 = 0;
                            break block26;
                        }
                        if (cArray2[n9] == '*' && n4 == 0) {
                            n6 = n9;
                            break;
                        }
                    }
                    cArray4[n8++] = cArray2[n9];
                }
                ++n9;
            }
            cArray2 = new char[n8];
            System.arraycopy(cArray4, 0, cArray2, 0, n8);
            n3 = CharOperation.indexOf('?', cArray2);
            n2 = n6 >= 0 ? (n3 >= 0 ? (n6 < n3 ? n6 : n3) : n6) : n3;
            switch (n2) {
                case -1: {
                    break;
                }
                case 0: {
                    cArray2 = null;
                    break;
                }
                default: {
                    cArray2 = CharOperation.subarray(cArray2, 0, n2);
                }
            }
        }
        if (cArray2 != null) {
            n5 += cArray2.length;
        } else {
            cArray5 = new char[n5];
            n7 = cArray.length;
            System.arraycopy(cArray, 0, cArray5, 0, n7);
            if (c != '\u0000') {
                cArray5[n7++] = c;
                cArray5[n7++] = 47;
            }
            return cArray5;
        }
        if (cArray3 != null) {
            int n10 = 0;
            while (n10 < cArray3.length) {
                if (cArray3[n10].length > 0) {
                    n5 += cArray3[n10].length;
                    ++n5;
                }
                ++n10;
            }
        }
        cArray4 = new char[n5];
        n7 = cArray.length;
        System.arraycopy(cArray, 0, cArray4, 0, n7);
        if (c != '\u0000') {
            cArray4[n7++] = c;
            cArray4[n7++] = 47;
        }
        System.arraycopy(cArray2, 0, cArray4, n7, cArray2.length);
        n7 += cArray2.length;
        if (cArray3 != null) {
            n4 = cArray3.length - 1;
            while (n4 >= 0) {
                if (n == 2) {
                    n6 = CharOperation.indexOf('*', cArray3[n4]);
                    n3 = CharOperation.indexOf('?', cArray3[n4]);
                    n2 = n6 >= 0 ? (n3 >= 0 ? (n6 < n3 ? n6 : n3) : n6) : n3;
                    if (n2 >= 0) {
                        cArray4[n7++] = 47;
                        System.arraycopy(cArray3[n4], 0, cArray4, n7, n2);
                        n7 += n6;
                        break;
                    }
                }
                if (cArray3[n4].length > 0) {
                    cArray4[n7++] = 47;
                    System.arraycopy(cArray3[n4], 0, cArray4, n7, cArray3[n4].length);
                    n7 += cArray3[n4].length;
                }
                --n4;
            }
        }
        if (n7 < n5) {
            cArray5 = new char[n7];
            System.arraycopy(cArray4, 0, cArray5, 0, n7);
        } else {
            cArray5 = cArray4;
        }
        return cArray5;
    }

    public static final char[] bestMacroPrefix(ICSearchConstants.LimitTo limitTo, char[] cArray, int n, boolean bl) {
        char[] cArray2 = null;
        if (limitTo != ICSearchConstants.DECLARATIONS) {
            return null;
        }
        cArray2 = IIndexConstants.MACRO_DECL;
        return AbstractIndexer.bestPrefix(cArray2, '\u0000', cArray, null, n, bl);
    }

    public static final char[] bestIncludePrefix(ICSearchConstants.LimitTo limitTo, char[] cArray, int n, boolean bl) {
        char[] cArray2 = null;
        if (limitTo != ICSearchConstants.REFERENCES) {
            return null;
        }
        cArray2 = IIndexConstants.INCLUDE_REF;
        return AbstractIndexer.bestPrefix(cArray2, '\u0000', cArray, null, n, bl);
    }

    public void addInclude(IASTInclusion iASTInclusion, IASTInclusion iASTInclusion2) {
        this.output.addIncludeRef(iASTInclusion.getFullFileName());
        this.output.addRelatives(iASTInclusion.getFullFileName(), iASTInclusion2 != null ? iASTInclusion2.getFullFileName() : null);
        String[] stringArray = new String[]{iASTInclusion.getFullFileName()};
        this.output.addRef(AbstractIndexer.encodeEntry(stringArray, IIndexConstants.INCLUDE_REF, 11));
    }

    public abstract void setFileTypes(String[] var1);
}

