/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;

public class NamespaceDeclarationPattern
extends CSearchPattern {
    private char[][] decodedContainingTypes;
    private char[] decodedSimpleName;
    private char[][] qualifications;
    private char[] simpleName;

    public NamespaceDeclarationPattern(char[] cArray, char[][] cArray2, int n, ICSearchConstants.LimitTo limitTo, boolean bl) {
        super(n, bl, limitTo);
        this.simpleName = cArray;
        this.qualifications = cArray2;
    }

    public int matchLevel(ISourceElementCallbackDelegate iSourceElementCallbackDelegate, ICSearchConstants.LimitTo limitTo) {
        if (!(iSourceElementCallbackDelegate instanceof IASTNamespaceDefinition) || !this.canAccept(limitTo)) {
            return 0;
        }
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iSourceElementCallbackDelegate;
        if (this.simpleName != null && !this.matchesName(this.simpleName, iASTNamespaceDefinition.getName().toCharArray())) {
            return 0;
        }
        String[] stringArray = iASTNamespaceDefinition.getFullyQualifiedName();
        char[][] cArray = new char[stringArray.length - 1][];
        int n = 0;
        while (n < stringArray.length - 1) {
            cArray[n] = stringArray[n].toCharArray();
            ++n;
        }
        if (!this.matchQualifications(this.qualifications, cArray)) {
            return 0;
        }
        return 2;
    }

    public void feedIndexRequestor(IIndexSearchRequestor iIndexSearchRequestor, int n, int[] nArray, IndexInput indexInput, ICSearchScope iCSearchScope) throws IOException {
        int n2 = 0;
        int n3 = nArray.length;
        while (n2 < n3) {
            String string;
            IndexedFile indexedFile = indexInput.getIndexedFile(nArray[n2]);
            if (indexedFile != null && iCSearchScope.encloses(string = indexedFile.getPath())) {
                iIndexSearchRequestor.acceptNamespaceDeclaration(string, this.decodedSimpleName, this.decodedContainingTypes);
            }
            ++n2;
        }
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
        this.decodedContainingTypes = null;
    }

    protected void decodeIndexEntry(IEntryResult iEntryResult) {
        char[] cArray = iEntryResult.getWord();
        int n = cArray.length;
        int n2 = CharOperation.indexOf('/', cArray, 0);
        int n3 = CharOperation.indexOf('/', cArray, n2 + 1);
        this.decodedSimpleName = CharOperation.subarray(cArray, n2 + 1, n3);
        if (n3 != -1 && n3 + 1 < n) {
            char[][] cArray2 = CharOperation.splitOn('/', CharOperation.subarray(cArray, n3 + 1, n));
            this.decodedContainingTypes = new char[cArray2.length][];
            int n4 = 0;
            while (n4 < cArray2.length) {
                this.decodedContainingTypes[n4] = cArray2[cArray2.length - n4 - 1];
                ++n4;
            }
        }
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestNamespacePrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
    }

    protected boolean matchIndexEntry() {
        if (this.simpleName != null && !this.matchesName(this.simpleName, this.decodedSimpleName)) {
            return false;
        }
        return this.matchQualifications(this.qualifications, this.decodedContainingTypes);
    }
}

