/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.ToolsProvider;
import org.eclipse.cdt.utils.elf.AR;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.parser.BinaryArchive;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryObject;
import org.eclipse.core.runtime.IPath;

public class ElfParser
extends ToolsProvider
implements IBinaryParser {
    public IBinaryParser.IBinaryFile getBinary(IPath iPath) throws IOException {
        return this.getBinary(null, iPath);
    }

    public IBinaryParser.IBinaryFile getBinary(byte[] byArray, IPath iPath) throws IOException {
        if (iPath == null) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.nullPath"));
        }
        IBinaryParser.IBinaryFile iBinaryFile = null;
        try {
            Elf.Attribute attribute = null;
            if (byArray != null && byArray.length > 0) {
                try {
                    attribute = Elf.getAttributes(byArray);
                }
                catch (EOFException eOFException) {}
            }
            if (attribute == null) {
                attribute = Elf.getAttributes(iPath.toOSString());
            }
            if (attribute != null) {
                switch (attribute.getType()) {
                    case 1: {
                        iBinaryFile = this.createBinaryExecutable(iPath);
                        break;
                    }
                    case 2: {
                        iBinaryFile = this.createBinaryShared(iPath);
                        break;
                    }
                    case 3: {
                        iBinaryFile = this.createBinaryObject(iPath);
                        break;
                    }
                    case 4: {
                        iBinaryFile = this.createBinaryCore(iPath);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iBinaryFile = this.createBinaryArchive(iPath);
        }
        return iBinaryFile;
    }

    public String getFormat() {
        return "ELF";
    }

    public boolean isBinary(byte[] byArray, IPath iPath) {
        return Elf.isElfHeader(byArray) || AR.isARHeader(byArray);
    }

    public int getHintBufferSize() {
        return 128;
    }

    protected IBinaryParser.IBinaryArchive createBinaryArchive(IPath iPath) throws IOException {
        return new BinaryArchive(this, iPath);
    }

    protected IBinaryParser.IBinaryObject createBinaryObject(IPath iPath) throws IOException {
        return new ElfBinaryObject(this, iPath);
    }

    protected IBinaryParser.IBinaryExecutable createBinaryExecutable(IPath iPath) throws IOException {
        return new ElfBinaryObject(this, iPath){

            public int getType() {
                return 2;
            }
        };
    }

    protected IBinaryParser.IBinaryShared createBinaryShared(IPath iPath) throws IOException {
        return new ElfBinaryObject(this, iPath){

            public int getType() {
                return 4;
            }
        };
    }

    protected IBinaryParser.IBinaryObject createBinaryCore(IPath iPath) throws IOException {
        return new ElfBinaryObject(this, iPath){

            public int getType() {
                return 16;
            }
        };
    }
}

