/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.AbstractDebugActionDelegate;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractListenerActionDelegate
extends AbstractDebugActionDelegate
implements IDebugEventSetListener,
IActionDelegate2 {
    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(final DebugEvent[] debugEventArray) {
        if (this.getWindow() == null || this.getAction() == null) {
            return;
        }
        Shell shell = this.getWindow().getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Shell shell = AbstractListenerActionDelegate.this.getWindow().getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                int n = 0;
                while (n < debugEventArray.length) {
                    if (debugEventArray[n].getSource() != null) {
                        AbstractListenerActionDelegate.this.doHandleDebugEvent(debugEventArray[n]);
                    }
                    ++n;
                }
            }
        };
        shell.getDisplay().asyncExec(runnable);
    }

    protected void doHandleDebugEvent(DebugEvent debugEvent) {
        switch (debugEvent.getKind()) {
            case 8: {
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 1: {
                if (debugEvent.isEvaluation() && (debugEvent.getDetail() & 0x80) != 0) break;
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 2: {
                this.update(this.getAction(), (ISelection)this.getSelection());
            }
        }
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        super.init(iWorkbenchWindow);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void init(IViewPart iViewPart) {
        super.init(iViewPart);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.setWindow(iViewPart.getViewSite().getWorkbenchWindow());
    }

    public void init(IAction iAction) {
    }

    public void runWithEvent(IAction iAction, Event event) {
        this.run(iAction);
    }
}

