/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage;
import org.eclipse.cdt.debug.internal.ui.actions.BreakpointLocationVerifier;
import org.eclipse.cdt.debug.internal.ui.editors.DisassemblyEditorInput;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class ManageBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private List fMarkers;
    private String fAddLabel;
    private String fRemoveLabel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ManageBreakpointRulerAction(IVerticalRulerInfo iVerticalRulerInfo, ITextEditor iTextEditor) {
        this.fRuler = iVerticalRulerInfo;
        this.fTextEditor = iTextEditor;
        this.fAddLabel = CDebugUIPlugin.getResourceString("internal.ui.actions.ManageBreakpointRulerAction.Add_Breakpoint");
        this.fRemoveLabel = CDebugUIPlugin.getResourceString("internal.ui.actions.ManageBreakpointRulerAction.Remove_Breakpoint");
    }

    public void update() {
        this.fMarkers = this.getMarkers();
        this.setText(this.fMarkers.isEmpty() ? this.fAddLabel : this.fRemoveLabel);
    }

    public void run() {
        if (this.fMarkers.isEmpty()) {
            this.addMarker();
        } else {
            this.removeMarkers(this.fMarkers);
        }
    }

    protected List getMarkers() {
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        IResource iResource = this.getResource();
        IDocument iDocument = this.getDocument();
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
        if (abstractMarkerAnnotationModel != null) {
            try {
                IWorkspaceRoot iWorkspaceRoot;
                IMarker[] iMarkerArray = null;
                if (iResource instanceof IFile && !(this.getTextEditor().getEditorInput() instanceof DisassemblyEditorInput)) {
                    iMarkerArray = iResource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                } else {
                    iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    iMarkerArray = iWorkspaceRoot.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                }
                if (iMarkerArray != null) {
                    iWorkspaceRoot = DebugPlugin.getDefault().getBreakpointManager();
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        IBreakpoint iBreakpoint = iWorkspaceRoot.getBreakpoint(iMarkerArray[n]);
                        if (iBreakpoint != null && iWorkspaceRoot.isRegistered(iBreakpoint) && this.includesRulerLine(abstractMarkerAnnotationModel.getMarkerPosition(iMarkerArray[n]), iDocument)) {
                            arrayList.add(iMarkerArray[n]);
                        }
                        ++n;
                    }
                }
            }
            catch (CoreException coreException) {
                CDebugUIPlugin.log(coreException.getStatus());
            }
        }
        return arrayList;
    }

    protected IResource getResource() {
        IResource iResource;
        IEditorInput iEditorInput = this.fTextEditor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iResource = (IResource)iEditorInput.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iResource = (IResource)iEditorInput.getAdapter((Class)clazz2);
        }
        return iResource;
    }

    protected boolean includesRulerLine(Position position, IDocument iDocument) {
        if (position != null) {
            try {
                int n = iDocument.getLineOfOffset(position.getOffset());
                int n2 = this.fRuler.getLineOfLastMouseButtonActivity();
                if (n2 == n) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel iAnnotationModel = iDocumentProvider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (iAnnotationModel instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)iAnnotationModel;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        return iDocumentProvider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected void addMarker() {
        block10: {
            IEditorInput iEditorInput = this.getTextEditor().getEditorInput();
            int n = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
            try {
                if (iEditorInput instanceof IFileEditorInput) {
                    this.createLineBreakpoint((IFileEditorInput)iEditorInput, n);
                    break block10;
                }
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.cdt.debug.internal.ui.editors.DisassemblyEditorInput");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (iEditorInput.getAdapter((Class)clazz) == null) break block10;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.cdt.debug.internal.ui.editors.DisassemblyEditorInput");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.createAddressBreakpoint((DisassemblyEditorInput)iEditorInput.getAdapter((Class)clazz2), n);
            }
            catch (DebugException debugException) {
                CDebugUIPlugin.errorDialog(CDebugUIPlugin.getResourceString("internal.ui.actions.ManageBreakpointRulerAction.Cannot_add_breakpoint"), debugException);
            }
            catch (CoreException coreException) {
                CDebugUIPlugin.errorDialog(CDebugUIPlugin.getResourceString("internal.ui.actions.ManageBreakpointRulerAction.Cannot_add_breakpoint"), coreException);
            }
        }
    }

    private void createLineBreakpoint(IFileEditorInput iFileEditorInput, int n) throws CoreException {
        String string;
        BreakpointLocationVerifier breakpointLocationVerifier = new BreakpointLocationVerifier();
        IDocument iDocument = this.getDocument();
        int n2 = breakpointLocationVerifier.getValidLineBreakpointLocation(iDocument, n);
        if (n2 > -1 && (string = iFileEditorInput.getFile().getLocation().toString()) != null && CDebugModel.lineBreakpointExists((String)string, (int)n2) == null) {
            CDebugModel.createLineBreakpoint((IResource)iFileEditorInput.getFile(), (int)n2, (boolean)true, (int)0, (String)"", (boolean)true);
        }
    }

    private void createAddressBreakpoint(DisassemblyEditorInput disassemblyEditorInput, int n) throws CoreException {
        BreakpointLocationVerifier breakpointLocationVerifier = new BreakpointLocationVerifier();
        IDocument iDocument = this.getDocument();
        int n2 = breakpointLocationVerifier.getValidAddressBreakpointLocation(iDocument, n);
        if (n2 > -1) {
            long l;
            IResource iResource;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)disassemblyEditorInput.getAdapter(clazz)) != null && disassemblyEditorInput.getStorage() != null && (l = ((IDisassemblyStorage)disassemblyEditorInput.getStorage()).getAddress(n2)) != 0L && CDebugModel.addressBreakpointExists((IResource)iResource, (long)l) == null) {
                CDebugModel.createAddressBreakpoint((IResource)iResource, (long)l, (boolean)true, (int)0, (String)"", (boolean)true);
            }
        }
    }

    protected void removeMarkers(List list) {
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IBreakpoint iBreakpoint = iBreakpointManager.getBreakpoint((IMarker)iterator.next());
                iBreakpointManager.removeBreakpoint(iBreakpoint, true);
            }
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.errorDialog(CDebugUIPlugin.getResourceString("internal.ui.actions.ManageBreakpointRulerAction.Cannot_remove_breakpoint"), coreException);
        }
    }
}

