/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewer;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.ui.AbstractDebugView;

public class MemoryViewEventHandler
extends AbstractDebugEventHandler {
    public MemoryViewEventHandler(AbstractDebugView abstractDebugView) {
        super(abstractDebugView);
    }

    protected void doHandleDebugEvents(DebugEvent[] debugEventArray) {
        int n = 0;
        while (n < debugEventArray.length) {
            DebugEvent debugEvent = debugEventArray[n];
            switch (debugEvent.getKind()) {
                case 16: {
                    if (!(debugEvent.getSource() instanceof IFormattedMemoryBlock) || debugEvent.getDetail() != 512) break;
                    this.refresh(debugEvent.getSource());
                    this.getView().updateObjects();
                    return;
                }
                case 8: {
                    if (!(debugEvent.getSource() instanceof IFormattedMemoryBlock)) break;
                    this.remove(debugEvent.getSource());
                    this.getView().updateObjects();
                    return;
                }
            }
            ++n;
        }
    }

    protected void refresh(Object object) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            ((MemoryViewer)this.getViewer()).refresh(object);
        }
    }

    public void refresh() {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getViewer().refresh();
        }
    }

    protected void remove(Object object) {
        ((MemoryViewer)this.getViewer()).remove(object);
    }
}

