/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.sharedlibs;

import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.ICSharedLibraryManager;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.internal.ui.CDTDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.actions.AutoRefreshAction;
import org.eclipse.cdt.debug.internal.ui.actions.LoadSymbolsForAllAction;
import org.eclipse.cdt.debug.internal.ui.actions.RefreshAction;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.sharedlibs.SharedLibrariesViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.sharedlibs.SharedLibrariesViewEventHandler;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.IUpdate;

public class SharedLibrariesView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler {
    static /* synthetic */ Class class$0;

    protected Viewer createViewer(Composite composite) {
        TableTreeViewer tableTreeViewer = new TableTreeViewer(composite, 66306);
        Table table = tableTreeViewer.getTableTree().getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        TableColumn[] tableColumnArray = table.getColumns();
        tableColumnArray[1].setResizable(true);
        tableColumnArray[2].setResizable(true);
        tableColumnArray[3].setResizable(true);
        tableColumnArray[0].setText("");
        tableColumnArray[1].setText(CDebugUIPlugin.getResourceString("SharedLibrariesView.Name"));
        tableColumnArray[2].setText(CDebugUIPlugin.getResourceString("SharedLibrariesView.Start_Address"));
        tableColumnArray[3].setText(CDebugUIPlugin.getResourceString("SharedLibrariesView.End_Address"));
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        tableColumnArray[0].setWidth(pixelConverter.convertWidthInCharsToPixels(3));
        tableColumnArray[1].setWidth(pixelConverter.convertWidthInCharsToPixels(50));
        tableColumnArray[2].setWidth(pixelConverter.convertWidthInCharsToPixels(20));
        tableColumnArray[3].setWidth(pixelConverter.convertWidthInCharsToPixels(20));
        tableTreeViewer.setContentProvider((IContentProvider)new SharedLibrariesViewContentProvider());
        tableTreeViewer.setLabelProvider((IBaseLabelProvider)new SharedLibrariesLabelProvider());
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(this.createEventHandler((Viewer)tableTreeViewer));
        return tableTreeViewer;
    }

    protected void createActions() {
        Action action = new AutoRefreshAction(this.getViewer(), CDebugUIPlugin.getResourceString("RegistersView.Auto_Refresh"));
        CDebugImages.setLocalImageDescriptors((IAction)action, "org.eclipse.cdt.debug.ui.autorefresh_mem.gif");
        action.setDescription("Automatically Refresh Shared Libraries View");
        action.setToolTipText(CDebugUIPlugin.getResourceString("RegistersView.Auto_Refresh"));
        WorkbenchHelp.setHelp((IAction)action, (String)ICDebugHelpContextIds.AUTO_REFRESH_SHARED_LIBRARIES_ACTION);
        action.setEnabled(false);
        this.setAction("AutoRefresh", (IAction)action);
        this.add((IUpdate)action);
        action = new RefreshAction(this.getViewer(), CDebugUIPlugin.getResourceString("RegistersView.Refresh"));
        CDebugImages.setLocalImageDescriptors((IAction)action, "org.eclipse.cdt.debug.ui.refresh_mem.gif");
        action.setDescription(CDebugUIPlugin.getResourceString("SharedLibrariesView.Refresh_Shared_Libraries_View"));
        action.setToolTipText(CDebugUIPlugin.getResourceString("RegistersView.Refresh"));
        WorkbenchHelp.setHelp((IAction)action, (String)ICDebugHelpContextIds.REFRESH_SHARED_LIBRARIES_ACTION);
        action.setEnabled(false);
        this.setAction("Refresh", (IAction)action);
        this.add((RefreshAction)action);
        action = new LoadSymbolsForAllAction(this.getViewer());
        action.setEnabled(false);
        this.setAction("LoadSymbolsForAll", (IAction)action);
        this.add((LoadSymbolsForAllAction)action);
        this.setInitialContent();
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.SHARED_LIBRARIES_VIEW;
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        this.updateObjects();
        iMenuManager.add((IContributionItem)new Separator("emptySharedLibrariesGroup"));
        iMenuManager.add((IContributionItem)new Separator("sharedLibrariesGroup"));
        iMenuManager.add((IContributionItem)new Separator("emptyRefreshGroup"));
        iMenuManager.add((IContributionItem)new Separator("refreshGroup"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.appendToGroup("sharedLibrariesGroup", this.getAction("LoadSymbolsForAll"));
        iMenuManager.appendToGroup("refreshGroup", this.getAction("AutoRefresh"));
        iMenuManager.appendToGroup("refreshGroup", this.getAction("Refresh"));
    }

    protected void configureToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator(this.getClass().getName()));
        iToolBarManager.add((IContributionItem)new Separator("sharedLibrariesGroup"));
        iToolBarManager.add(this.getAction("LoadSymbolsForAll"));
        iToolBarManager.add((IContributionItem)new Separator("refreshGroup"));
        iToolBarManager.add(this.getAction("AutoRefresh"));
        iToolBarManager.add(this.getAction("Refresh"));
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)iSelection);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void handleException(DebugException debugException) {
    }

    protected void setViewerInput(IStructuredSelection iStructuredSelection) {
        Object object;
        ICSharedLibraryManager iCSharedLibraryManager = null;
        if (iStructuredSelection != null && iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof IDebugElement) {
            IDebugTarget iDebugTarget = ((IDebugElement)object).getDebugTarget();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICSharedLibraryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iCSharedLibraryManager = (ICSharedLibraryManager)iDebugTarget.getAdapter((Class)clazz);
        }
        if (this.getViewer() == null) {
            return;
        }
        object = this.getViewer().getInput();
        if (object != null && object.equals(iCSharedLibraryManager)) {
            this.updateObjects();
            return;
        }
        this.showViewer();
        this.getViewer().setInput(iCSharedLibraryManager);
        this.updateObjects();
    }

    protected void setInitialContent() {
        ISelection iSelection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            this.setViewerInput((IStructuredSelection)iSelection);
        } else {
            this.setViewerInput(null);
        }
    }

    protected AbstractDebugEventHandler createEventHandler(Viewer viewer) {
        return new SharedLibrariesViewEventHandler(this);
    }

    public class SharedLibrariesLabelProvider
    extends CDTDebugModelPresentation
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int n) {
            if (object instanceof ICSharedLibrary && n == 1) {
                return this.getImage(object);
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof ICSharedLibrary) {
                ICSharedLibrary iCSharedLibrary = (ICSharedLibrary)object;
                switch (n) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return this.getText(object);
                    }
                    case 2: {
                        return iCSharedLibrary.getStartAddress() > 0L ? CDebugUtils.toHexAddressString((long)iCSharedLibrary.getStartAddress()) : "";
                    }
                    case 3: {
                        return iCSharedLibrary.getEndAddress() > 0L ? CDebugUtils.toHexAddressString((long)iCSharedLibrary.getEndAddress()) : "";
                    }
                }
            }
            return null;
        }
    }
}

