/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.util.StringMatcher;
import org.eclipse.cdt.internal.ui.util.TwoArrayQuickSort;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SelectionList
extends Composite {
    private Object[] fElements;
    protected ILabelProvider fRenderer;
    private boolean fIgnoreCase;
    private String[] fRenderedStrings;
    private int[] fFilteredElements;
    private String fRememberedMatchText;
    private Table fList;
    private Text fText;

    public void addSelectionListener(SelectionListener selectionListener) {
        this.fList.addSelectionListener(selectionListener);
    }

    private void createList(int n) {
        this.fList = new Table((Composite)this, n);
        this.fList.setLayoutData((Object)new GridData(1808));
        this.fList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SelectionList.this.fRenderer.dispose();
            }
        });
    }

    private void createText() {
        this.fText = new Text((Composite)this, 2048);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.fText.setLayoutData((Object)gridData);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                SelectionList.this.filter(false);
            }
        };
        this.fText.addListener(24, listener);
    }

    public void filter(boolean bl) {
        int n = 0;
        String string = this.fText.getText();
        if (!bl && string.equals(this.fRememberedMatchText)) {
            return;
        }
        this.fRememberedMatchText = string;
        StringMatcher stringMatcher = new StringMatcher(String.valueOf(string) + "*", this.fIgnoreCase, false);
        int n2 = 0;
        while (n2 < this.fElements.length) {
            if (stringMatcher.match(this.fRenderedStrings[n2])) {
                this.fFilteredElements[n] = n2;
                ++n;
            }
            ++n2;
        }
        this.fFilteredElements[n] = -1;
        this.updateListWidget(this.fFilteredElements, n);
    }

    public String getFilter() {
        return this.fText.getText();
    }

    public int[] getSelectionIndices() {
        return this.fList.getSelectionIndices();
    }

    public List getSelection() {
        if (this.fList == null || this.fList.isDisposed() || this.fList.getSelectionCount() == 0) {
            return new ArrayList(0);
        }
        int[] nArray = this.fList.getSelectionIndices();
        ArrayList<Object> arrayList = new ArrayList<Object>(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            arrayList.add(this.fElements[this.fFilteredElements[nArray[n]]]);
            ++n;
        }
        return arrayList;
    }

    public boolean isEmptyList() {
        return this.fElements == null || this.fElements.length == 0;
    }

    public SelectionList(Composite composite, int n, ILabelProvider iLabelProvider, boolean bl) {
        super(composite, 0);
        this.fRenderer = iLabelProvider;
        this.fIgnoreCase = bl;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.createText();
        this.createList(n);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.fList.removeSelectionListener(selectionListener);
    }

    private String[] renderStrings() {
        String[] stringArray = new String[this.fElements.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.fRenderer.getText(this.fElements[n]);
            ++n;
        }
        TwoArrayQuickSort.sort(stringArray, this.fElements, this.fIgnoreCase);
        return stringArray;
    }

    public void selectFilterText() {
        this.fText.selectAll();
    }

    public void setElements(List list, boolean bl) {
        this.fElements = list == null ? new Object[0] : list.toArray();
        this.fFilteredElements = new int[this.fElements.length + 1];
        this.fRenderedStrings = this.renderStrings();
        if (bl) {
            this.filter(true);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.fText.setEnabled(bl);
        this.fList.setEnabled(bl);
    }

    public void setFilter(String string, boolean bl) {
        this.fText.setText(string);
        if (bl) {
            this.filter(true);
        }
    }

    public boolean setFocus() {
        return this.fText.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fText.setFont(font);
        this.fList.setFont(font);
    }

    protected void setSelection(int[] nArray) {
        this.fList.setSelection(nArray);
    }

    private void updateListWidget(int[] nArray, int n) {
        if (this.fList == null || this.fList.isDisposed()) {
            return;
        }
        this.fList.setRedraw(false);
        int n2 = this.fList.getItemCount();
        if (n < n2) {
            this.fList.remove(0, n2 - n - 1);
        }
        TableItem[] tableItemArray = this.fList.getItems();
        int n3 = 0;
        while (n3 < n) {
            TableItem tableItem = null;
            tableItem = n3 < n2 ? tableItemArray[n3] : new TableItem(this.fList, n3);
            tableItem.setText(this.fRenderedStrings[nArray[n3]]);
            Image image = this.fRenderer.getImage(this.fElements[nArray[n3]]);
            if (image != null) {
                tableItem.setImage(image);
            }
            ++n3;
        }
        if (this.fList.getItemCount() > 0) {
            this.fList.setSelection(0);
        }
        this.fList.setRedraw(true);
        Event event = new Event();
        this.fList.notifyListeners(13, event);
    }
}

