/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.internal.ui.dialogs.MessageLine;
import org.eclipse.cdt.internal.ui.dialogs.StatusTool;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class SelectionStatusDialog
extends SelectionDialog {
    private MessageLine fStatusLine;
    private IStatus fLastStatus;
    private Image fImage;
    private boolean fInitialSelectionSet = false;
    private boolean fStatusLineAboveButtons = false;

    protected abstract void computeResult();

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fImage != null) {
            shell.setImage(this.fImage);
        }
    }

    protected Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        if (this.fStatusLineAboveButtons) {
            gridLayout.verticalSpacing = 0;
        } else {
            gridLayout.numColumns = 2;
        }
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.fStatusLine = new MessageLine(composite2);
        this.fStatusLine.setAlignment(16384);
        this.fStatusLine.setLayoutData(new GridData(768));
        this.fStatusLine.setMessage("");
        super.createButtonBar(composite2);
        return composite2;
    }

    public void create() {
        super.create();
        if (this.fLastStatus != null) {
            this.updateStatus(this.fLastStatus);
        }
    }

    protected Object getPrimaryInitialSelection() {
        List list = this.getInitialElementSelections();
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public Object getPrimaryResult() {
        Object[] objectArray = this.getResult();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        return objectArray[0];
    }

    public SelectionStatusDialog(Shell shell) {
        super(shell);
    }

    protected void okPressed() {
        this.computeResult();
        super.okPressed();
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    protected void setInitialSelection(int n, Object object) {
        List list = this.getInitialElementSelections();
        list.set(n, object);
        this.fInitialSelectionSet = true;
    }

    public void setInitialSelection(Object object) {
        if (this.fInitialSelectionSet && object != null && object.equals("A")) {
            return;
        }
        if (object != null) {
            this.setInitialSelections(new Object[]{object});
        } else {
            this.setInitialSelections(new Object[0]);
        }
    }

    public void setInitialSelections(Object[] objectArray) {
        super.setInitialSelections(objectArray);
        this.fInitialSelectionSet = true;
    }

    protected void setResult(int n, Object object) {
        Object[] objectArray = this.getResult();
        objectArray[n] = object;
        this.setResult(Arrays.asList(objectArray));
    }

    public void setStatusLineAboveButtons(boolean bl) {
        this.fStatusLineAboveButtons = bl;
    }

    protected void updateButtonsEnableState(IStatus iStatus) {
        Button button = this.getOkButton();
        if (button != null && !button.isDisposed()) {
            button.setEnabled(!iStatus.matches(4));
        }
    }

    protected void updateStatus(IStatus iStatus) {
        this.fLastStatus = iStatus;
        if (this.fStatusLine != null && !this.fStatusLine.isDisposed()) {
            this.updateButtonsEnableState(iStatus);
            StatusTool.applyToStatusLine(this.fStatusLine, iStatus);
        }
    }
}

