/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs;

import org.eclipse.cdt.internal.ui.dialogs.MessageLine;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class StatusDialog
extends Dialog {
    private Button fOkButton;
    private MessageLine fStatusLine;
    private IStatus fLastStatus;
    private String fTitle;
    private Image fImage;
    private boolean fStatusLineAboveButtons = false;

    public StatusDialog(Shell shell) {
        super(shell);
    }

    public void setStatusLineAboveButtons(boolean bl) {
        this.fStatusLineAboveButtons = bl;
    }

    protected void updateStatus(IStatus iStatus) {
        this.fLastStatus = iStatus;
        if (this.fStatusLine != null && !this.fStatusLine.isDisposed()) {
            this.updateButtonsEnableState(iStatus);
            this.fStatusLine.setErrorMessage(iStatus.getMessage());
        }
    }

    public IStatus getStatus() {
        return this.fLastStatus;
    }

    protected void updateButtonsEnableState(IStatus iStatus) {
        if (this.fOkButton != null && !this.fOkButton.isDisposed()) {
            this.fOkButton.setEnabled(!iStatus.matches(4));
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    public void create() {
        super.create();
        if (this.fLastStatus != null) {
            if (this.fLastStatus.matches(4)) {
                StatusInfo statusInfo = new StatusInfo();
                statusInfo.setError("");
                this.fLastStatus = statusInfo;
            }
            this.updateStatus(this.fLastStatus);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.fOkButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.fStatusLine = new MessageLine(composite2);
        this.fStatusLine.setAlignment(16384);
        this.fStatusLine.setLayoutData(new GridData(768));
        this.fStatusLine.setErrorMessage(null);
        super.createButtonBar(composite2);
        return composite2;
    }

    public void setTitle(String string) {
        this.fTitle = string != null ? string : "";
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(this.fTitle);
        }
    }

    public void setImage(Image image) {
        this.fImage = image;
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setImage(this.fImage);
        }
    }
}

