/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.drag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.drag.TransferDragSourceListener;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceTransferDragAdapter
implements TransferDragSourceListener {
    private final ISelectionProvider provider;
    static /* synthetic */ Class class$0;

    public ResourceTransferDragAdapter(ISelectionProvider iSelectionProvider) {
        this.provider = iSelectionProvider;
        Assert.isNotNull((Object)iSelectionProvider);
    }

    public Transfer getTransfer() {
        return ResourceTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.doit = false;
        ISelection iSelection = this.provider.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                IResource iResource;
                Object e = iterator.next();
                if (!(e instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
                    dragSourceEvent.doit = false;
                    break;
                }
                dragSourceEvent.doit = true;
            }
        }
    }

    public void dragSetData(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.data = this.getSelectedResources();
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (dragSourceEvent.doit && dragSourceEvent.detail == 2) {
            IResource[] iResourceArray = this.getSelectedResources();
            if (iResourceArray.length == 0) {
                return;
            }
            DragSource dragSource = (DragSource)dragSourceEvent.widget;
            Control control = dragSource.getControl();
            Shell shell = control.getShell();
            String string = CUIMessages.getString("Drag.move.problem.title");
            String string2 = CUIMessages.getString("Drag.move.problem.message");
            ReadOnlyStateChecker readOnlyStateChecker = new ReadOnlyStateChecker(shell, string, string2);
            iResourceArray = readOnlyStateChecker.checkReadOnlyResources(iResourceArray);
            int n = 0;
            while (n < iResourceArray.length) {
                try {
                    iResourceArray[n].delete(3, null);
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
                ++n;
            }
        }
    }

    private IResource[] getSelectedResources() {
        IResource[] iResourceArray;
        ArrayList<IResource> arrayList = Collections.EMPTY_LIST;
        ISelection iSelection = this.provider.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            iResourceArray = (IResource[])iSelection;
            arrayList = new ArrayList<IResource>(iResourceArray.size());
            Iterator iterator = iResourceArray.iterator();
            while (iterator.hasNext()) {
                IResource iResource;
                Object e = iterator.next();
                if (!(e instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) continue;
                arrayList.add(iResource);
            }
        }
        iResourceArray = new IResource[arrayList.size()];
        arrayList.toArray(iResourceArray);
        return iResourceArray;
    }
}

