/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.cdt.internal.ui.CFileElementWorkingCopy;
import org.eclipse.cdt.internal.ui.StandardCElementLabelProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.FileSearchAction;
import org.eclipse.cdt.internal.ui.editor.FileSearchActionInWorkingSet;
import org.eclipse.cdt.internal.ui.editor.LexicalSortingAction;
import org.eclipse.cdt.internal.ui.editor.OpenIncludeAction;
import org.eclipse.cdt.internal.ui.editor.SearchDialogAction;
import org.eclipse.cdt.internal.ui.editor.TogglePresentationAction;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.actions.MemberFilterActionGroup;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CContentOutlinePage
extends Page
implements IContentOutlinePage,
ISelectionChangedListener {
    private CEditor fEditor;
    private IWorkingCopy fInput;
    private ProblemTreeViewer treeViewer;
    private ListenerList selectionChangedListeners = new ListenerList();
    private TogglePresentationAction fTogglePresentation;
    private String fContextMenuId;
    private OpenIncludeAction fOpenIncludeAction;
    private FileSearchAction fFileSearchAction;
    private FileSearchActionInWorkingSet fFileSearchActionInWorkingSet;
    private SearchDialogAction fSearchDialogAction;
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private ActionGroup fSelectionSearchGroup;

    public CContentOutlinePage(CEditor cEditor) {
        this("#TranslationUnitOutlinerContext", cEditor);
    }

    public CContentOutlinePage(String string, CEditor cEditor) {
        this.fEditor = cEditor;
        this.fInput = null;
        this.fContextMenuId = string;
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setEditor((ITextEditor)cEditor);
        this.fOpenIncludeAction = new OpenIncludeAction((ISelectionProvider)this);
        this.fFileSearchAction = new FileSearchAction((ISelectionProvider)this);
        this.fFileSearchActionInWorkingSet = new FileSearchActionInWorkingSet((ISelectionProvider)this);
        this.fSearchDialogAction = new SearchDialogAction((ISelectionProvider)this, cEditor);
    }

    public ICElement getRoot() {
        return this.fInput;
    }

    public void contentUpdated() {
        TreeViewer treeViewer;
        if (this.fInput != null && (treeViewer = this.getTreeViewer()) != null && !treeViewer.getControl().isDisposed()) {
            treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!treeViewer.getControl().isDisposed()) {
                        ISelection iSelection = treeViewer.getSelection();
                        treeViewer.getControl().setRedraw(false);
                        treeViewer.refresh();
                        treeViewer.setSelection(CContentOutlinePage.this.updateSelection(iSelection));
                        treeViewer.getControl().setRedraw(true);
                    }
                }
            });
        }
    }

    protected ISelection updateSelection(ISelection iSelection) {
        ArrayList<ICElement> arrayList = new ArrayList<ICElement>();
        if (iSelection instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator.hasNext()) {
                ICElement iCElement = (ICElement)iterator.next();
                if (iCElement == null) continue;
                arrayList.add(iCElement);
            }
        }
        return new StructuredSelection(arrayList);
    }

    protected void contextMenuAboutToShow(IMenuManager iMenuManager) {
        if (OpenIncludeAction.canActionBeAdded(this.getSelection())) {
            iMenuManager.add((IAction)this.fOpenIncludeAction);
        }
        if (SearchDialogAction.canActionBeAdded(this.getSelection())) {
            iMenuManager.add((IAction)this.fSearchDialogAction);
        }
        if (FileSearchAction.canActionBeAdded(this.getSelection())) {
            MenuManager menuManager = new MenuManager(CEditorMessages.getString("CContentOutlinePage.menu.fileSearch"));
            menuManager.add((IAction)this.fFileSearchAction);
            menuManager.add((IAction)this.fFileSearchActionInWorkingSet);
            iMenuManager.add((IContributionItem)menuManager);
        }
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("additions-end"));
        this.fSelectionSearchGroup.fillContextMenu(iMenuManager);
    }

    public void createControl(Composite composite) {
        this.treeViewer = new ProblemTreeViewer(composite, 770);
        this.treeViewer.addSelectionChangedListener(this);
        this.treeViewer.setContentProvider((IContentProvider)new CElementContentProvider(true, true));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new StandardCElementLabelProvider());
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.addSelectionChangedListener(this);
        CUIPlugin.getDefault().getProblemMarkerManager().addListener(this.treeViewer);
        MenuManager menuManager = new MenuManager(this.fContextMenuId);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                CContentOutlinePage.this.contextMenuAboutToShow(iMenuManager);
            }
        });
        Control control = this.treeViewer.getControl();
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
        this.fSelectionSearchGroup = new SelectionSearchGroup(this);
        IPageSite iPageSite = this.getSite();
        iPageSite.registerContextMenu(this.fContextMenuId, menuManager, (ISelectionProvider)this.treeViewer);
        iPageSite.setSelectionProvider((ISelectionProvider)this.treeViewer);
        IActionBars iActionBars = iPageSite.getActionBars();
        iActionBars.setGlobalActionHandler("org.eclipse.cdt.ui.edit.text.c.toggle.presentation", (IAction)this.fTogglePresentation);
        this.registerToolbarActions();
        IEditorInput iEditorInput = this.fEditor.getEditorInput();
        IDocumentProvider iDocumentProvider = this.fEditor.getDocumentProvider();
        try {
            if (iEditorInput instanceof IFileEditorInput) {
                IWorkingCopyManager iWorkingCopyManager = CUIPlugin.getDefault().getWorkingCopyManager();
                this.fInput = (WorkingCopy)iWorkingCopyManager.getWorkingCopy(iEditorInput);
                if (this.fInput == null) {
                    this.fInput = new CFileElementWorkingCopy((IStorageEditorInput)((IFileEditorInput)iEditorInput), iDocumentProvider);
                }
            } else if (iEditorInput instanceof IStorageEditorInput) {
                this.fInput = new CFileElementWorkingCopy((IStorageEditorInput)iEditorInput, iDocumentProvider);
            } else {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, CEditorMessages.getString("CContentOutlinePage.error.noInput"), null));
            }
            this.treeViewer.setInput(this.fInput);
        }
        catch (CoreException coreException) {
            CUIPlugin.getDefault().log(coreException.getStatus());
            this.fInput = null;
        }
    }

    public void dispose() {
        CUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.treeViewer);
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        super.dispose();
    }

    public void setActionBars(IActionBars iActionBars) {
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        LexicalSortingAction lexicalSortingAction = new LexicalSortingAction(this.getTreeViewer());
        iToolBarManager.add((IAction)lexicalSortingAction);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.add((Object)iSelectionChangedListener);
    }

    protected void fireSelectionChanged(ISelection iSelection) {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, iSelection);
        Object[] objectArray = this.selectionChangedListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((ISelectionChangedListener)objectArray[n]).selectionChanged(selectionChangedEvent);
            ++n;
        }
    }

    public Control getControl() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getControl();
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.remove((Object)iSelectionChangedListener);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.fireSelectionChanged(selectionChangedEvent.getSelection());
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void setSelection(ISelection iSelection) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection(iSelection);
        }
    }

    public void setInput(IWorkingCopy iWorkingCopy) {
        this.fInput = iWorkingCopy;
        if (this.treeViewer != null) {
            this.treeViewer.setInput(this.fInput);
        }
        this.contentUpdated();
    }

    private void registerToolbarActions() {
        IToolBarManager iToolBarManager = this.getSite().getActionBars().getToolBarManager();
        if (iToolBarManager != null) {
            this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this.treeViewer, "COutlineViewer");
            this.fMemberFilterActionGroup.contributeToToolBar(iToolBarManager);
        }
    }
}

