/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.opentype;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.internal.ui.opentype.OpenTypeMessages;
import org.eclipse.core.resources.IFile;

public class TypeSearchMatch
extends BasicSearchMatch {
    public String getFileName() {
        if (this.resource != null) {
            return this.resource.getName();
        }
        if (this.path != null) {
            return this.path.lastSegment();
        }
        return null;
    }

    public String getFilePath() {
        if (this.resource != null) {
            return this.resource.getFullPath().toString();
        }
        if (this.path != null) {
            return this.path.toString();
        }
        return null;
    }

    public String getFileExtension() {
        if (this.resource != null) {
            return this.resource.getFileExtension();
        }
        if (this.path != null) {
            return this.path.getFileExtension();
        }
        return null;
    }

    public String getQualifiedParentName() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getFileName();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(string2);
        }
        if ((string = this.getParentName()) != null && string.length() > 0) {
            stringBuffer.append(OpenTypeMessages.getString("TypeInfoLabelProvider.colon"));
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getFullyQualifiedName() {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = this.getFilePath();
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(string3);
        }
        if ((string2 = this.getParentName()) != null && string2.length() > 0) {
            stringBuffer.append(OpenTypeMessages.getString("TypeInfoLabelProvider.colon"));
            stringBuffer.append(string2);
            stringBuffer.append("::");
        }
        if ((string = this.getName()) != null && string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private boolean matchesCType(ICElement iCElement, String string) {
        switch (iCElement.getElementType()) {
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 73: 
            case 78: {
                return iCElement.getElementName().equals(string);
            }
        }
        return false;
    }

    private ICElement findCElement(ICElement iCElement, String string) {
        if (this.matchesCType(iCElement, string)) {
            return iCElement;
        }
        if (iCElement instanceof IParent) {
            ICElement[] iCElementArray = ((IParent)iCElement).getChildren();
            int n = 0;
            while (n < iCElementArray.length) {
                if (this.matchesCType(iCElementArray[n], string)) {
                    return iCElementArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public ICElement getCElement() {
        ICElement iCElement;
        if (this.resource != null && this.resource.getType() == 1 && (iCElement = CoreModel.getDefault().create((IFile)this.resource)) instanceof IParent) {
            String string = this.getParentName();
            while (iCElement != null && string != null && string.length() > 0) {
                int n = string.indexOf("::");
                if (n >= 0) {
                    iCElement = this.findCElement(iCElement, string.substring(0, n));
                    string = string.substring(n + 2);
                    continue;
                }
                iCElement = this.findCElement(iCElement, string);
                string = null;
            }
            if (iCElement != null) {
                return this.findCElement(iCElement, this.getName());
            }
        }
        return null;
    }
}

