/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.opentype.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.ui.opentype.OpenTypeMessages;
import org.eclipse.cdt.internal.ui.opentype.TypeSearchMatch;
import org.eclipse.cdt.internal.ui.opentype.TypeSearchMatchLabelProvider;
import org.eclipse.cdt.internal.ui.opentype.TypeSearchOperation;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.util.StringMatcher;
import org.eclipse.cdt.internal.ui.util.Strings;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class TypeSelectionDialog
extends TwoPaneElementSelector {
    private IRunnableContext fRunnableContext;
    private ICSearchScope fScope;

    public TypeSelectionDialog(Shell shell, IRunnableContext iRunnableContext, ICSearchScope iCSearchScope) {
        super(shell, (ILabelProvider)new TypeSearchMatchLabelProvider(16), (ILabelProvider)new TypeSearchMatchLabelProvider(40));
        Assert.isNotNull((Object)iRunnableContext);
        Assert.isNotNull((Object)iCSearchScope);
        this.fRunnableContext = iRunnableContext;
        this.fScope = iCSearchScope;
        this.setUpperListLabel(OpenTypeMessages.getString("TypeSelectionDialog.upperLabel"));
        this.setLowerListLabel(OpenTypeMessages.getString("TypeSelectionDialog.lowerLabel"));
    }

    protected FilteredList createFilteredList(Composite composite) {
        FilteredList filteredList = super.createFilteredList(composite);
        ((AbstractElementListSelectionDialog)this).fFilteredList.setFilterMatcher((FilteredList.FilterMatcher)new TypeFilterMatcher());
        ((AbstractElementListSelectionDialog)this).fFilteredList.setComparator((Comparator)new StringComparator());
        return filteredList;
    }

    public int open() {
        TypeSearchOperation typeSearchOperation = new TypeSearchOperation(CUIPlugin.getWorkspace(), this.fScope, new SearchEngine());
        try {
            this.fRunnableContext.run(true, true, (IRunnableWithProgress)typeSearchOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, OpenTypeMessages.getString("TypeSelectionDialog.error3Title"), OpenTypeMessages.getString("TypeSelectionDialog.error3Message"));
            return 1;
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        Object[] objectArray = typeSearchOperation.getResults();
        if (objectArray.length == 0) {
            String string = OpenTypeMessages.getString("TypeSelectionDialog.notypes.title");
            String string2 = OpenTypeMessages.getString("TypeSelectionDialog.notypes.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)string, (String)string2);
            return 1;
        }
        this.setElements(objectArray);
        return super.open();
    }

    protected void computeResult() {
        TypeSearchMatch typeSearchMatch = (TypeSearchMatch)((Object)this.getLowerSelectedElement());
        if (typeSearchMatch == null) {
            return;
        }
        ArrayList<TypeSearchMatch> arrayList = new ArrayList<TypeSearchMatch>(1);
        arrayList.add(typeSearchMatch);
        this.setResult(arrayList);
    }

    private static class TypeFilterMatcher
    implements FilteredList.FilterMatcher {
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private StringMatcher fMatcher;
        private StringMatcher fQualifierMatcher;

        TypeFilterMatcher() {
        }

        public void setFilter(String string, boolean bl, boolean bl2) {
            int n = string.lastIndexOf("::");
            if (n == -1) {
                this.fQualifierMatcher = null;
                this.fMatcher = new StringMatcher(this.adjustPattern(string), bl, bl2);
            } else {
                this.fQualifierMatcher = new StringMatcher(string.substring(0, n), bl, bl2);
                this.fMatcher = new StringMatcher(this.adjustPattern(string.substring(n + 2)), bl, bl2);
            }
        }

        public boolean match(Object object) {
            if (!(object instanceof TypeSearchMatch)) {
                return false;
            }
            TypeSearchMatch typeSearchMatch = (TypeSearchMatch)((Object)object);
            if (!this.fMatcher.match(typeSearchMatch.getName())) {
                return false;
            }
            if (this.fQualifierMatcher == null) {
                return true;
            }
            return this.fQualifierMatcher.match(typeSearchMatch.getFullyQualifiedName());
        }

        private String adjustPattern(String string) {
            int n = string.length();
            if (n > 0) {
                switch (string.charAt(n - 1)) {
                    case '<': {
                        string = string.substring(0, n - 1);
                        break;
                    }
                    case '*': {
                        break;
                    }
                    default: {
                        string = String.valueOf(string) + '*';
                    }
                }
            }
            return string;
        }
    }

    private static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            String string = (String)object;
            String string2 = (String)object2;
            if (string.length() != 0 && string2.length() != 0) {
                if (Strings.isLowerCase(string.charAt(0)) && !Strings.isLowerCase(string2.charAt(0))) {
                    return 1;
                }
                if (Strings.isLowerCase(string2.charAt(0)) && !Strings.isLowerCase(string.charAt(0))) {
                    return -1;
                }
            }
            if ((n = string.compareToIgnoreCase(string2)) == 0) {
                n = string.compareTo(string2);
            }
            return n;
        }
    }
}

