/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.io.IOException;
import java.io.Reader;

public class HTMLPrinter {
    private HTMLPrinter() {
    }

    private static String replace(String string, char c, String string2) {
        int n = 0;
        int n2 = string.indexOf(c, n);
        if (n2 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 > -1) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string2);
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String convertToHTMLContent(String string) {
        string = HTMLPrinter.replace(string, '<', "&lt;");
        return HTMLPrinter.replace(string, '>', "&gt;");
    }

    public static String read(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[2048];
        try {
            int n = reader.read(cArray);
            while (n > 0) {
                stringBuffer.append(cArray, 0, n);
                n = reader.read(cArray);
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void insertPageProlog(StringBuffer stringBuffer, int n) {
        stringBuffer.insert(n, "<html><body text=\"#000000\" bgcolor=\"#FFFF88\"><font size=-1>");
    }

    public static void addPageProlog(StringBuffer stringBuffer) {
        HTMLPrinter.insertPageProlog(stringBuffer, stringBuffer.length());
    }

    public static void addPageEpilog(StringBuffer stringBuffer) {
        stringBuffer.append("</font></body></html>");
    }

    public static void startBulletList(StringBuffer stringBuffer) {
        stringBuffer.append("<ul>");
    }

    public static void endBulletList(StringBuffer stringBuffer) {
        stringBuffer.append("</ul>");
    }

    public static void addBullet(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append("<li>");
            stringBuffer.append(string);
            stringBuffer.append("</li>");
        }
    }

    public static void addSmallHeader(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append("<h5>");
            stringBuffer.append(string);
            stringBuffer.append("</h5>");
        }
    }

    public static void addParagraph(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append("<p>");
            stringBuffer.append(string);
        }
    }

    public static void addParagraph(StringBuffer stringBuffer, Reader reader) {
        if (reader != null) {
            HTMLPrinter.addParagraph(stringBuffer, HTMLPrinter.read(reader));
        }
    }
}

