/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchResultCollector;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CSearchResultLabelProvider
extends LabelProvider {
    public static final int SHOW_NAME_ONLY = 0;
    public static final int SHOW_ELEMENT_CONTAINER = 1;
    public static final int SHOW_CONTAINER_ELEMENT = 2;
    public static final int SHOW_PATH = 3;
    public static final String POTENTIAL_MATCH = CSearchMessages.getString("CSearchResultLabelProvider.potentialMatch");
    private int _sortOrder = 3;
    private int _textFlags;
    private int _imageFlags;
    private static final Point SMALL_SIZE = new Point(16, 16);

    public Image getImage(Object object) {
        Object object2;
        IMatch iMatch = null;
        if (object instanceof ISearchResultViewEntry) {
            object2 = (ISearchResultViewEntry)object;
            IMarker iMarker = object2.getSelectedMarker();
            try {
                iMatch = (IMatch)iMarker.getAttribute(CSearchResultCollector.IMATCH);
            }
            catch (CoreException coreException) {
                return null;
            }
        } else if (object instanceof IMatch) {
            iMatch = (IMatch)object;
        }
        if (iMatch == null) {
            return null;
        }
        object2 = null;
        block1 : switch (iMatch.getElementType()) {
            case 64: {
                object2 = CPluginImages.DESC_OBJS_CLASS;
                break;
            }
            case 65: {
                object2 = CPluginImages.DESC_OBJS_STRUCT;
                break;
            }
            case 66: {
                object2 = CPluginImages.DESC_OBJS_UNION;
                break;
            }
            case 61: {
                object2 = CPluginImages.DESC_OBJS_CONTAINER;
                break;
            }
            case 63: {
                object2 = CPluginImages.DESC_OBJS_ENUMERATION;
                break;
            }
            case 77: {
                object2 = CPluginImages.DESC_OBJS_MACRO;
                break;
            }
            case 71: {
                object2 = CPluginImages.DESC_OBJS_FUNCTION;
                break;
            }
            case 74: {
                object2 = CPluginImages.DESC_OBJS_VARIABLE;
                break;
            }
            case 79: {
                object2 = CPluginImages.DESC_OBJS_ENUMERATOR;
                break;
            }
            case 78: {
                object2 = CPluginImages.DESC_OBJS_TYPEDEF;
                break;
            }
            case 69: {
                switch (iMatch.getVisibility()) {
                    case 8192: {
                        object2 = CPluginImages.DESC_OBJS_PUBLIC_FIELD;
                        break block1;
                    }
                    case 4096: {
                        object2 = CPluginImages.DESC_OBJS_PRIVATE_FIELD;
                        break block1;
                    }
                }
                object2 = CPluginImages.DESC_OBJS_PROTECTED_FIELD;
                break;
            }
            case 67: {
                switch (iMatch.getVisibility()) {
                    case 8192: {
                        object2 = CPluginImages.DESC_OBJS_PUBLIC_METHOD;
                        break block1;
                    }
                    case 4096: {
                        object2 = CPluginImages.DESC_OBJS_PRIVATE_METHOD;
                        break block1;
                    }
                }
                object2 = CPluginImages.DESC_OBJS_PROTECTED_METHOD;
            }
        }
        int n = 0;
        if (iMatch.isStatic()) {
            n |= 8;
        }
        if (iMatch.isConst()) {
            n |= 2;
        }
        if (iMatch.isVolatile()) {
            n |= 4;
        }
        object2 = new CElementImageDescriptor((ImageDescriptor)object2, n, SMALL_SIZE);
        Image image = CUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)object2);
        return image;
    }

    public String getText(Object object) {
        Object object2;
        ISearchResultViewEntry iSearchResultViewEntry;
        IMatch iMatch = null;
        if (object instanceof ISearchResultViewEntry) {
            iSearchResultViewEntry = (ISearchResultViewEntry)object;
            object2 = iSearchResultViewEntry.getSelectedMarker();
            try {
                iMatch = (IMatch)object2.getAttribute(CSearchResultCollector.IMATCH);
            }
            catch (CoreException coreException) {
                return "";
            }
        } else if (object instanceof IMatch) {
            iMatch = (IMatch)object;
        }
        if (iMatch == null) {
            return "";
        }
        iSearchResultViewEntry = iMatch.getResource();
        object2 = "";
        String string = iSearchResultViewEntry != null ? iSearchResultViewEntry.getFullPath().toString() : "";
        switch (this.getOrder()) {
            case 0: {
                object2 = iMatch.getName();
            }
            case 1: {
                if (!iMatch.getParentName().equals("")) {
                    object2 = String.valueOf(iMatch.getName()) + " - " + iMatch.getParentName() + " ( " + string + " )";
                    break;
                }
                object2 = String.valueOf(iMatch.getName()) + " ( " + string + " )";
                break;
            }
            case 3: {
                object2 = String.valueOf(string) + " - " + iMatch.getParentName() + "::" + iMatch.getName();
                break;
            }
            case 2: {
                object2 = String.valueOf(iMatch.getParentName()) + "::" + iMatch.getName() + " ( " + string + " )";
            }
        }
        return object2;
    }

    public int getOrder() {
        return this._sortOrder;
    }

    public void setOrder(int n) {
        this._sortOrder = n;
    }
}

