/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.io.File;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.internal.ui.GDBSolibBlock;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class GDBDebuggerPage
extends AbstractLaunchConfigurationTab
implements Observer {
    protected TabFolder fTabFolder;
    protected Text fGDBCommandText;
    protected Text fGDBInitText;
    private GDBSolibBlock fSolibBlock;

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.fTabFolder = new TabFolder(composite2, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(1808));
        this.createTabs(this.fTabFolder);
        this.fTabFolder.setSelection(0);
        this.setControl((Control)composite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        iLaunchConfigurationWorkingCopy.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, "");
        if (this.fSolibBlock != null) {
            this.fSolibBlock.setDefaults(iLaunchConfigurationWorkingCopy);
        }
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl;
        boolean bl2 = bl = this.fGDBCommandText.getText().length() != 0;
        if (bl) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage("Debugger executable must be specified");
            this.setMessage(null);
        }
        return bl;
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        String string = "gdb";
        String string2 = "";
        try {
            string = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            string2 = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, "");
        }
        catch (CoreException coreException) {}
        this.fGDBCommandText.setText(string);
        this.fGDBInitText.setText(string2);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.initializeFrom(iLaunchConfiguration);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = this.fGDBCommandText.getText();
        string.trim();
        iLaunchConfigurationWorkingCopy.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, string);
        string = this.fGDBInitText.getText();
        string.trim();
        iLaunchConfigurationWorkingCopy.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, string);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.performApply(iLaunchConfigurationWorkingCopy);
        }
    }

    public String getName() {
        return "GDB Debugger Options";
    }

    protected Shell getShell() {
        return super.getShell();
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void update(Observable observable, Object object) {
        this.updateLaunchConfigurationDialog();
    }

    public GDBSolibBlock createSolibBlock(Composite composite) {
        GDBSolibBlock gDBSolibBlock = new GDBSolibBlock();
        gDBSolibBlock.createBlock(composite, true, true, true);
        return gDBSolibBlock;
    }

    public void createTabs(TabFolder tabFolder) {
        this.createMainTab(tabFolder);
        this.createSolibTab(tabFolder);
    }

    public void createMainTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Main");
        Composite composite = ControlFactory.createCompositeEx((Composite)this.fTabFolder, (int)1, (int)1808);
        ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = false;
        tabItem.setControl((Control)composite);
        Composite composite2 = ControlFactory.createCompositeEx((Composite)composite, (int)3, (int)768);
        ((GridLayout)composite2.getLayout()).makeColumnsEqualWidth = false;
        Label label = ControlFactory.createLabel((Composite)composite2, (String)"GDB debugger:");
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.fGDBCommandText = ControlFactory.createTextField((Composite)composite2, (int)2052);
        this.fGDBCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        Button button = this.createPushButton(composite2, "&Browse...", null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.handleGDBButtonSelected();
                GDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBButtonSelected() {
                String string;
                FileDialog fileDialog = new FileDialog(GDBDebuggerPage.this.getShell(), 0);
                fileDialog.setText("GDB Command File");
                String string2 = GDBDebuggerPage.this.fGDBCommandText.getText().trim();
                int n = string2.lastIndexOf(File.separator);
                if (n != -1) {
                    fileDialog.setFilterPath(string2.substring(0, n));
                }
                if ((string = fileDialog.open()) == null) {
                    return;
                }
                GDBDebuggerPage.this.fGDBCommandText.setText(string);
            }
        });
        label = ControlFactory.createLabel((Composite)composite2, (String)"GDB command file:");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.fGDBInitText = ControlFactory.createTextField((Composite)composite2, (int)2052);
        gridData = new GridData(768);
        this.fGDBInitText.setLayoutData((Object)gridData);
        this.fGDBInitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        button = this.createPushButton(composite2, "&Browse...", null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.handleGDBInitButtonSelected();
                GDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBInitButtonSelected() {
                String string;
                FileDialog fileDialog = new FileDialog(GDBDebuggerPage.this.getShell(), 0);
                fileDialog.setText("GDB command file");
                String string2 = GDBDebuggerPage.this.fGDBInitText.getText().trim();
                int n = string2.lastIndexOf(File.separator);
                if (n != -1) {
                    fileDialog.setFilterPath(string2.substring(0, n));
                }
                if ((string = fileDialog.open()) == null) {
                    return;
                }
                GDBDebuggerPage.this.fGDBInitText.setText(string);
            }
        });
        label = ControlFactory.createLabel((Composite)composite, (String)"(Warning: Some commands in this file may interfere with the startup operation of the debugger, for example \"run\".)", (int)200, (int)-1, (int)64);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 200;
        label.setLayoutData((Object)gridData);
    }

    public void createSolibTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Shared Libraries");
        Composite composite = ControlFactory.createCompositeEx((Composite)this.fTabFolder, (int)1, (int)1808);
        tabItem.setControl((Control)composite);
        this.fSolibBlock = this.createSolibBlock(composite);
        this.fSolibBlock.addObserver(this);
    }

    public void dispose() {
        if (this.fSolibBlock != null) {
            this.fSolibBlock.deleteObserver(this);
            this.fSolibBlock.dispose();
        }
        super.dispose();
    }
}

