/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

public class FileStorage
extends PlatformObject
implements IStorage {
    IPath path;
    InputStream in = null;

    public InputStream getContents() throws CoreException {
        if (this.in == null) {
            try {
                return new FileInputStream(this.path.toFile());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 4, fileNotFoundException.toString(), (Throwable)fileNotFoundException));
            }
        }
        return this.in;
    }

    public IPath getFullPath() {
        return this.path;
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public FileStorage(IPath iPath) {
        this.path = iPath;
    }

    public FileStorage(InputStream inputStream, IPath iPath) {
        this.path = iPath;
        this.in = inputStream;
    }

    public String toString() {
        return this.path.toOSString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IStorage) {
            IPath iPath = this.getFullPath();
            IPath iPath2 = ((IStorage)object).getFullPath();
            if (iPath != null && iPath2 != null) {
                return iPath.equals((Object)iPath2);
            }
        }
        return super.equals(object);
    }
}

