/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;

public final class IncludeEntryHashedArray {
    public IncludeEntry[] elements;
    public int elementSize;
    public int threshold;

    public IncludeEntryHashedArray(int n) {
        if (n < 7) {
            n = 7;
        }
        this.elements = new IncludeEntry[2 * n + 1];
        this.elementSize = 0;
        this.threshold = n + 1;
    }

    public IncludeEntry add(IncludeEntry includeEntry) {
        IncludeEntry includeEntry2;
        int n = this.elements.length;
        char[] cArray = includeEntry.getFile();
        int n2 = CharOperation.hashCode(cArray) % n;
        while ((includeEntry2 = this.elements[n2]) != null) {
            if (CharOperation.equals(includeEntry2.getFile(), cArray)) {
                this.elements[n2] = includeEntry;
                return this.elements[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.elements[n2] = includeEntry;
        if (++this.elementSize > this.threshold) {
            this.grow();
        }
        return includeEntry;
    }

    public IncludeEntry[] asArray() {
        IncludeEntry[] includeEntryArray = new IncludeEntry[this.elementSize];
        int n = 0;
        int n2 = 0;
        int n3 = this.elements.length;
        while (n < n3) {
            IncludeEntry includeEntry = this.elements[n];
            if (includeEntry != null) {
                includeEntryArray[n2++] = includeEntry;
            }
            ++n;
        }
        return includeEntryArray;
    }

    public IncludeEntry get(char[] cArray) {
        IncludeEntry includeEntry;
        int n = this.elements.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        while ((includeEntry = this.elements[n2]) != null) {
            if (CharOperation.equals(includeEntry.getFile(), cArray)) {
                return includeEntry;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    private void grow() {
        IncludeEntryHashedArray includeEntryHashedArray = new IncludeEntryHashedArray(this.elementSize * 2);
        int n = 0;
        int n2 = this.elements.length;
        while (n < n2) {
            if (this.elements[n] != null) {
                includeEntryHashedArray.add(this.elements[n]);
            }
            ++n;
        }
        this.elements = includeEntryHashedArray.elements;
        this.elementSize = includeEntryHashedArray.elementSize;
        this.threshold = includeEntryHashedArray.threshold;
    }

    public String toString() {
        String string = "";
        IncludeEntry[] includeEntryArray = this.asArray();
        int n = 0;
        int n2 = includeEntryArray.length;
        while (n < n2) {
            string = String.valueOf(string) + includeEntryArray[n].toString() + "\n";
            ++n;
        }
        return string;
    }
}

