/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICModelStatusConstants;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CModelStatus
extends Status
implements ICModelStatus,
ICModelStatusConstants,
IResourceStatus {
    protected ICElement[] fElements = new ICElement[0];
    protected IPath fPath;
    protected String fString;
    protected static final IStatus[] fgEmptyChildren = new IStatus[0];
    protected IStatus[] fChildren = fgEmptyChildren;
    public static final ICModelStatus VERIFIED_OK = new CModelStatus(0, 0, Util.bind("status.OK"));

    public CModelStatus() {
        super(4, "org.eclipse.cdt.core", 0, "CModelStatus", null);
    }

    public CModelStatus(int n) {
        super(4, "org.eclipse.cdt.core", n, "CModelStatus", null);
        this.fElements = CElementInfo.fgEmptyChildren;
    }

    public CModelStatus(int n, ICElement[] iCElementArray) {
        super(4, "org.eclipse.cdt.core", n, "CModelStatus", null);
        this.fElements = iCElementArray;
        this.fPath = null;
    }

    public CModelStatus(int n, String string) {
        this(4, n, string);
    }

    public CModelStatus(int n, int n2, String string) {
        super(n, "org.eclipse.cdt.core", n2, "CModelStatus", null);
        this.fElements = CElementInfo.fgEmptyChildren;
        this.fPath = null;
        this.fString = string;
    }

    public CModelStatus(int n, Throwable throwable) {
        super(4, "org.eclipse.cdt.core", n, "CModelStatus", throwable);
        this.fElements = CElementInfo.fgEmptyChildren;
    }

    public CModelStatus(int n, IPath iPath) {
        super(4, "org.eclipse.cdt.core", n, "CModelStatus", null);
        this.fElements = CElementInfo.fgEmptyChildren;
        this.fPath = iPath;
    }

    public CModelStatus(int n, ICElement iCElement) {
        this(n, new ICElement[]{iCElement});
    }

    public CModelStatus(int n, ICElement iCElement, String string) {
        this(n, new ICElement[]{iCElement});
        this.fString = string;
    }

    public CModelStatus(int n, ICElement iCElement, IPath iPath) {
        this(n, new ICElement[]{iCElement});
        this.fPath = iPath;
    }

    public CModelStatus(CoreException coreException) {
        super(4, "org.eclipse.cdt.core", 966, "CModelStatus", (Throwable)coreException);
    }

    protected int getBits() {
        int n = 1 << this.getCode() % 100 / 33;
        int n2 = 1 << this.getCode() / 100 + 3;
        return n | n2;
    }

    public IStatus[] getChildren() {
        return this.fChildren;
    }

    public ICElement[] getElements() {
        return this.fElements;
    }

    public String getMessage() {
        return CCorePlugin.getResourceString("CoreModel.CModelStatus.Error_in_CPlugin");
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getSeverity() {
        if (this.fChildren == fgEmptyChildren) {
            return super.getSeverity();
        }
        int n = -1;
        int n2 = 0;
        int n3 = this.fChildren.length;
        while (n2 < n3) {
            int n4 = this.fChildren[n2].getSeverity();
            if (n4 > n) {
                n = n4;
            }
            ++n2;
        }
        return n;
    }

    public String getString() {
        return this.fString;
    }

    public boolean doesNotExist() {
        return this.getCode() == 969;
    }

    public boolean isMultiStatus() {
        return this.fChildren != fgEmptyChildren;
    }

    public boolean isOK() {
        return this.getCode() == 0;
    }

    public boolean matches(int n) {
        if (!this.isMultiStatus()) {
            return this.matches(this, n);
        }
        int n2 = 0;
        int n3 = this.fChildren.length;
        while (n2 < n3) {
            if (this.matches((CModelStatus)this.fChildren[n2], n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean matches(CModelStatus cModelStatus, int n) {
        int n2 = n & 7;
        int n3 = n & 0xFFFFFFF8;
        int n4 = cModelStatus.getBits();
        return !(n2 != 0 && (n4 & n2) == 0 || n3 != 0 && (n4 & n3) == 0);
    }

    public static ICModelStatus newMultiStatus(ICModelStatus[] iCModelStatusArray) {
        CModelStatus cModelStatus = new CModelStatus();
        cModelStatus.fChildren = iCModelStatusArray;
        return cModelStatus;
    }

    public String toString() {
        if (this == VERIFIED_OK) {
            return "CModelStatus[OK]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("C Model Status [");
        stringBuffer.append(this.getMessage());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

