/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.BufferChangedEvent;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.IBufferChangedListener;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class Openable
extends Parent
implements IOpenable,
IBufferChangedListener {
    protected IResource resource;

    public Openable(ICElement iCElement, IPath iPath, int n) {
        this(iCElement, (IResource)ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(iPath), iPath.lastSegment(), n);
    }

    public Openable(ICElement iCElement, IResource iResource, int n) {
        this(iCElement, iResource, iResource.getName(), n);
    }

    public Openable(ICElement iCElement, IResource iResource, String string, int n) {
        super(iCElement, string, n);
        this.resource = iResource;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void bufferChanged(BufferChangedEvent bufferChangedEvent) {
        if (bufferChangedEvent.getBuffer().isClosed()) {
            CModelManager.getDefault().getElementsOutOfSynchWithBuffers().remove(this);
            this.getBufferManager().removeBuffer(bufferChangedEvent.getBuffer());
        } else {
            CModelManager.getDefault().getElementsOutOfSynchWithBuffers().put(this, this);
        }
    }

    protected void buildStructure(OpenableInfo openableInfo, IProgressMonitor iProgressMonitor) throws CModelException {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return;
        }
        this.removeInfo();
        HashMap hashMap = new HashMap(11);
        openableInfo.setIsStructureKnown(this.generateInfos(openableInfo, iProgressMonitor, hashMap, this.getResource()));
        CModelManager.getDefault().getElementsOutOfSynchWithBuffers().remove(this);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            ICElement iCElement = (ICElement)iterator.next();
            Object v = hashMap.get(iCElement);
            CModelManager.getDefault().putInfo(iCElement, v);
        }
        CModelManager.getDefault().putInfo(this, openableInfo);
    }

    protected void closeBuffer(OpenableInfo openableInfo) {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer iBuffer = null;
        iBuffer = this.getBufferManager().getBuffer(this);
        if (iBuffer != null) {
            iBuffer.close();
            iBuffer.removeBufferChangedListener(this);
        }
    }

    protected abstract boolean generateInfos(OpenableInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws CModelException;

    public IBuffer getBuffer() throws CModelException {
        if (this.hasBuffer()) {
            IBuffer iBuffer;
            if (!this.isOpen()) {
                this.getElementInfo();
            }
            if ((iBuffer = this.getBufferManager().getBuffer(this)) == null) {
                iBuffer = this.openBuffer(null);
            }
            return iBuffer;
        }
        return null;
    }

    public IBufferFactory getBufferFactory() {
        return this.getBufferManager().getDefaultBufferFactory();
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    protected boolean hasBuffer() {
        return false;
    }

    public boolean hasUnsavedChanges() throws CModelException {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer != null && iBuffer.hasUnsavedChanges()) {
            return true;
        }
        if (this.fType == 10 || this.fType == 11) {
            Enumeration enumeration = this.getBufferManager().getOpenBuffers();
            while (enumeration.hasMoreElements()) {
                ICElement iCElement;
                IBuffer iBuffer2 = (IBuffer)enumeration.nextElement();
                if (!iBuffer2.hasUnsavedChanges() || !this.isAncestorOf(iCElement = (ICElement)((Object)iBuffer2.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConsistent() throws CModelException {
        return true;
    }

    public boolean isOpen() {
        CModelManager cModelManager = CModelManager.getDefault();
        synchronized (cModelManager) {
            return CModelManager.getDefault().getInfo(this) != null;
        }
    }

    protected boolean isSourceElement() {
        return false;
    }

    public void makeConsistent(IProgressMonitor iProgressMonitor) throws CModelException {
        this.makeConsistent(iProgressMonitor, false);
    }

    public void makeConsistent(IProgressMonitor iProgressMonitor, boolean bl) throws CModelException {
        if (!this.isConsistent() || bl) {
            this.buildStructure((OpenableInfo)this.getElementInfo(), iProgressMonitor);
        }
    }

    public void open(IProgressMonitor iProgressMonitor) throws CModelException {
        if (!this.isOpen()) {
            this.openWhenClosed(iProgressMonitor);
        }
    }

    protected IBuffer openBuffer(IProgressMonitor iProgressMonitor) throws CModelException {
        return null;
    }

    protected void openParent(IProgressMonitor iProgressMonitor) throws CModelException {
        Openable openable = (Openable)this.getOpenableParent();
        if (openable != null && !openable.isOpen()) {
            openable.openWhenClosed(iProgressMonitor);
        }
    }

    protected void openWhenClosed(IProgressMonitor iProgressMonitor) throws CModelException {
        try {
            this.openParent(iProgressMonitor);
            OpenableInfo openableInfo = (OpenableInfo)this.createElementInfo();
            IResource iResource = this.getResource();
            if (iResource != null && this.isSourceElement()) {
                this.openBuffer(iProgressMonitor);
            }
            this.buildStructure(openableInfo, iProgressMonitor);
        }
        catch (CModelException cModelException) {
            CModelManager.getDefault().removeInfo(this);
            throw cModelException;
        }
    }

    public void save(IProgressMonitor iProgressMonitor, boolean bl) throws CModelException {
        if (this.isReadOnly() || this.getResource().isReadOnly()) {
            throw new CModelException(new CModelStatus(976, this));
        }
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer != null) {
            iBuffer.save(iProgressMonitor, bl);
            this.makeConsistent(iProgressMonitor);
        }
    }
}

