/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.StructureInfo;

public class Structure
extends SourceManipulation
implements IStructure {
    Map superClassesNames = new TreeMap();

    public Structure(ICElement iCElement, int n, String string) {
        super(iCElement, string, n);
    }

    public IField[] getFields() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getChildrenOfType(69));
        return arrayList.toArray(new IField[arrayList.size()]);
    }

    public IField getField(String string) {
        IField[] iFieldArray = this.getFields();
        int n = 0;
        while (n < iFieldArray.length) {
            IField iField = iFieldArray[n];
            if (iField.getElementName().equals(string)) {
                return iField;
            }
            ++n;
        }
        return null;
    }

    public IMethodDeclaration[] getMethods() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getChildrenOfType(68));
        arrayList.addAll(this.getChildrenOfType(67));
        return arrayList.toArray(new IMethodDeclaration[arrayList.size()]);
    }

    public IMethodDeclaration getMethod(String string) {
        IMethodDeclaration[] iMethodDeclarationArray = this.getMethods();
        int n = 0;
        while (n < iMethodDeclarationArray.length) {
            IMethodDeclaration iMethodDeclaration = iMethodDeclarationArray[n];
            if (iMethodDeclaration.getElementName().equals(string)) {
                return iMethodDeclaration;
            }
            ++n;
        }
        return null;
    }

    public boolean isUnion() {
        return this.getStructureInfo().isUnion();
    }

    public boolean isClass() {
        return this.getStructureInfo().isClass();
    }

    public boolean isStruct() {
        return this.getStructureInfo().isStruct();
    }

    public boolean isAbstract() {
        IMethodDeclaration[] iMethodDeclarationArray = this.getMethods();
        int n = 0;
        while (n < iMethodDeclarationArray.length) {
            IMethodDeclaration iMethodDeclaration = iMethodDeclarationArray[n];
            if (iMethodDeclaration.isPureVirtual()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String[] getSuperClassesNames() {
        return this.superClassesNames.keySet().toArray(new String[this.superClassesNames.keySet().size()]);
    }

    public ASTAccessVisibility getSuperClassAccess(String string) {
        return (ASTAccessVisibility)this.superClassesNames.get(string);
    }

    public String getTypeName() {
        return this.getStructureInfo().getTypeName();
    }

    public void setTypeName(String string) {
        this.getStructureInfo().setTypeString(string);
    }

    public boolean isConst() {
        return this.getStructureInfo().isConst();
    }

    public void setConst(boolean bl) {
        this.getStructureInfo().setConst(bl);
    }

    public boolean isVolatile() {
        return this.getStructureInfo().isVolatile();
    }

    public void setVolatile(boolean bl) {
        this.getStructureInfo().setVolatile(bl);
    }

    public boolean isStatic() {
        return this.getStructureInfo().isStatic();
    }

    public void setStatic(boolean bl) {
        this.getStructureInfo().setStatic(bl);
    }

    public StructureInfo getStructureInfo() {
        return (StructureInfo)this.getElementInfo();
    }

    public void addSuperClass(String string) {
        this.superClassesNames.put(string, ASTAccessVisibility.PUBLIC);
    }

    public void addSuperClass(String string, ASTAccessVisibility aSTAccessVisibility) {
        this.superClassesNames.put(string, aSTAccessVisibility);
    }

    protected CElementInfo createElementInfo() {
        return new StructureInfo(this);
    }
}

