/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

class RemoveFolderFromIndex
extends IndexRequest {
    IPath folderPath;
    char[][] exclusionPatterns;
    IProject project;

    public RemoveFolderFromIndex(IPath iPath, char[][] cArray, IProject iProject, IndexManager indexManager) {
        super(iProject.getFullPath(), indexManager);
        this.folderPath = iPath;
        this.exclusionPatterns = cArray;
        this.project = iProject;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return true;
        }
        IIndex iIndex = this.manager.getIndex(this.indexPath, true, false);
        if (iIndex == null) {
            return true;
        }
        ReadWriteMonitor readWriteMonitor = this.manager.getMonitorFor(iIndex);
        if (readWriteMonitor == null) {
            return true;
        }
        try {
            try {
                int n;
                readWriteMonitor.enterRead();
                IQueryResult[] iQueryResultArray = iIndex.queryInDocumentNames(this.folderPath.toString());
                int n2 = 0;
                int n3 = n = iQueryResultArray == null ? 0 : iQueryResultArray.length;
                while (n2 < n) {
                    String string = iQueryResultArray[n2].getPath();
                    if (this.exclusionPatterns == null || !Util.isExcluded((IPath)new Path(string), this.exclusionPatterns)) {
                        this.manager.remove(string, this.indexPath);
                    }
                    ++n2;
                }
            }
            catch (IOException iOException) {
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> failed to remove " + this.folderPath + " from index because of the following exception:");
                    iOException.printStackTrace();
                }
                Object var8_9 = null;
                readWriteMonitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            readWriteMonitor.exitRead();
            throw throwable;
        }
        {
            Object var8_11 = null;
            readWriteMonitor.exitRead();
            return true;
        }
    }

    public String toString() {
        return "removing " + this.folderPath + " from index " + this.indexPath;
    }
}

