/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug;

import org.eclipse.cdt.utils.debug.DebugArrayType;
import org.eclipse.cdt.utils.debug.DebugBaseType;
import org.eclipse.cdt.utils.debug.DebugCrossRefType;
import org.eclipse.cdt.utils.debug.DebugDerivedType;
import org.eclipse.cdt.utils.debug.DebugEnumField;
import org.eclipse.cdt.utils.debug.DebugEnumType;
import org.eclipse.cdt.utils.debug.DebugField;
import org.eclipse.cdt.utils.debug.DebugFunctionType;
import org.eclipse.cdt.utils.debug.DebugPointerType;
import org.eclipse.cdt.utils.debug.DebugReferenceType;
import org.eclipse.cdt.utils.debug.DebugStructType;
import org.eclipse.cdt.utils.debug.DebugUnknownType;

public class DebugType {
    protected DebugType() {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this instanceof DebugArrayType) {
            DebugArrayType debugArrayType = (DebugArrayType)this;
            int n = debugArrayType.getSize();
            DebugType debugType = debugArrayType.getComponentType();
            stringBuffer.append(debugType.toString());
            stringBuffer.append(" [").append(n).append(']');
        } else if (this instanceof DebugDerivedType) {
            DebugType debugType;
            DebugDerivedType debugDerivedType = (DebugDerivedType)this;
            DebugType debugType2 = debugDerivedType.getComponentType();
            if (debugType2 instanceof DebugStructType) {
                debugType = (DebugStructType)debugType2;
                stringBuffer.append(((DebugStructType)debugType).getName());
            } else if (debugType2 != null) {
                stringBuffer.append(debugType2.toString());
            }
            if (this instanceof DebugPointerType) {
                stringBuffer.append(" *");
            } else if (this instanceof DebugReferenceType) {
                stringBuffer.append(" &");
            } else if (this instanceof DebugCrossRefType && debugType2 == null) {
                debugType = (DebugCrossRefType)this;
                stringBuffer.append(((DebugCrossRefType)debugType).getCrossRefName());
            }
        } else if (this instanceof DebugBaseType) {
            DebugBaseType debugBaseType = (DebugBaseType)this;
            String string = debugBaseType.getTypeName();
            stringBuffer.append(string);
        } else if (this instanceof DebugFunctionType) {
            DebugFunctionType debugFunctionType = (DebugFunctionType)this;
            DebugType debugType = debugFunctionType.getReturnType();
            stringBuffer.append(debugType.toString());
            stringBuffer.append(" (*())");
        } else if (this instanceof DebugEnumType) {
            DebugEnumType debugEnumType = (DebugEnumType)this;
            DebugEnumField[] debugEnumFieldArray = debugEnumType.getDebugEnumFields();
            stringBuffer.append("enum ").append(debugEnumType.getName()).append(" {");
            int n = 0;
            while (n < debugEnumFieldArray.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(' ').append(debugEnumFieldArray[n].getName());
                stringBuffer.append(" = ").append(debugEnumFieldArray[n].getValue());
                ++n;
            }
            stringBuffer.append(" }");
        } else if (this instanceof DebugStructType) {
            DebugStructType debugStructType = (DebugStructType)this;
            if (debugStructType.isUnion()) {
                stringBuffer.append("union ");
            } else {
                stringBuffer.append("struct ");
            }
            stringBuffer.append(debugStructType.getName()).append(" {");
            DebugField[] debugFieldArray = debugStructType.getDebugFields();
            int n = 0;
            while (n < debugFieldArray.length) {
                if (n > 0) {
                    stringBuffer.append(';');
                }
                stringBuffer.append(' ').append(debugFieldArray[n].getDebugType());
                stringBuffer.append(' ').append(debugFieldArray[n].getName());
                ++n;
            }
            stringBuffer.append(" }");
        } else if (this instanceof DebugUnknownType) {
            DebugUnknownType debugUnknownType = (DebugUnknownType)this;
            stringBuffer.append(debugUnknownType.getName());
        }
        return stringBuffer.toString();
    }
}

