/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.dwarf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.debug.DebugUnknownType;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.tools.DebugSym;
import org.eclipse.cdt.utils.debug.tools.DebugSymsRequestor;
import org.eclipse.cdt.utils.elf.Elf;

public class Dwarf {
    static final String DWARF_DEBUG_INFO = ".debug_info";
    static final String DWARF_DEBUG_ABBREV = ".debug_abbrev";
    static final String DWARF_DEBUG_ARANGES = ".debug_aranges";
    static final String DWARF_DEBUG_LINE = ".debug_line";
    static final String DWARF_DEBUG_FRAME = ".debug_frame";
    static final String DWARF_EH_FRAME = ".eh_frame";
    static final String DWARF_DEBUG_LOC = ".debug_loc";
    static final String DWARF_DEBUG_PUBNAMES = ".debug_pubnames";
    static final String DWARF_DEBUG_STR = ".debug_str";
    static final String DWARF_DEBUG_FUNCNAMES = ".debug_funcnames";
    static final String DWARF_DEBUG_TYPENAMES = ".debug_typenames";
    static final String DWARF_DEBUG_VARNAMES = ".debug_varnames";
    static final String DWARF_DEBUG_WEAKNAMES = ".debug_weaknames";
    static final String DWARF_DEBUG_MACINFO = ".debug_macinfo";
    static final String[] DWARF_SCNNAMES = new String[]{".debug_info", ".debug_abbrev", ".debug_aranges", ".debug_line", ".debug_frame", ".eh_frame", ".debug_loc", ".debug_pubnames", ".debug_str", ".debug_funcnames", ".debug_typenames", ".debug_varnames", ".debug_weaknames", ".debug_macinfo"};
    Map dwarfSections = new HashMap();
    Map abbreviationMaps = new HashMap();
    boolean isLE;
    CompileUnit currentCU;
    private int num_leb128_read;

    public Dwarf(String string) throws IOException {
        Elf elf = new Elf(string);
        this.init(elf);
        elf.dispose();
    }

    public Dwarf(Elf elf) throws IOException {
        this.init(elf);
    }

    public void init(Elf elf) throws IOException {
        Elf.ELFhdr eLFhdr = elf.getELFhdr();
        this.isLE = eLFhdr.e_ident[5] == 1;
        Elf.Section[] sectionArray = elf.getSections();
        int n = 0;
        while (n < sectionArray.length) {
            String string = sectionArray[n].toString();
            int n2 = 0;
            while (n2 < DWARF_SCNNAMES.length) {
                if (string.equals(DWARF_SCNNAMES[n2])) {
                    this.dwarfSections.put(DWARF_SCNNAMES[n2], sectionArray[n].loadSectionData());
                }
                ++n2;
            }
            ++n;
        }
    }

    int read_4_bytes(InputStream inputStream) throws IOException {
        try {
            byte[] byArray = new byte[4];
            int n = inputStream.read(byArray, 0, byArray.length);
            if (n != 4) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
            }
            return this.read_4_bytes(byArray, 0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
        }
    }

    int read_4_bytes(byte[] byArray, int n) throws IndexOutOfBoundsException {
        if (this.isLE) {
            return (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
        }
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    long read_8_bytes(InputStream inputStream) throws IOException {
        try {
            byte[] byArray = new byte[8];
            int n = inputStream.read(byArray, 0, byArray.length);
            if (n != 8) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
            }
            return this.read_8_bytes(byArray, 0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
        }
    }

    long read_8_bytes(byte[] byArray, int n) throws IndexOutOfBoundsException {
        if (this.isLE) {
            return (byArray[n + 7] & 0xFF) << 56 | (byArray[n + 6] & 0xFF) << 48 | (byArray[n + 5] & 0xFF) << 40 | (byArray[n + 4] & 0xFF) << 32 | (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
        }
        return (byArray[n] & 0xFF) << 56 | (byArray[n + 1] & 0xFF) << 48 | (byArray[n + 2] & 0xFF) << 40 | (byArray[n + 3] & 0xFF) << 32 | (byArray[n + 4] & 0xFF) << 24 | (byArray[n + 5] & 0xFF) << 16 | (byArray[n + 6] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    short read_2_bytes(InputStream inputStream) throws IOException {
        try {
            byte[] byArray = new byte[2];
            int n = inputStream.read(byArray, 0, byArray.length);
            if (n != 2) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
            }
            return this.read_2_bytes(byArray, 0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
        }
    }

    short read_2_bytes(byte[] byArray, int n) throws IndexOutOfBoundsException {
        if (this.isLE) {
            return (short)(((byArray[n + 1] & 0xFF) << 8) + (byArray[n] & 0xFF));
        }
        return (short)(((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF));
    }

    long read_unsigned_leb128(InputStream inputStream) throws IOException {
        short s;
        long l = 0L;
        this.num_leb128_read = 0;
        int n = 0;
        while ((s = (short)inputStream.read()) != -1) {
            ++this.num_leb128_read;
            l |= (long)(s & 0x7F) << n;
            if ((s & 0x80) == 0) break;
            n += 7;
        }
        return l;
    }

    long read_signed_leb128(InputStream inputStream) throws IOException {
        short s;
        long l = 0L;
        int n = 0;
        int n2 = 32;
        this.num_leb128_read = 0;
        do {
            if ((s = (short)inputStream.read()) == -1) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.noData"));
            }
            ++this.num_leb128_read;
            l |= (long)(s & 0x7F) << n;
            n += 7;
        } while ((s & 0x80) != 0);
        if (n < n2 && (s & 0x40) != 0) {
            l |= (long)(-(1 << n));
        }
        return l;
    }

    public void parse(IDebugEntryRequestor iDebugEntryRequestor) {
        this.parseDebugInfo(iDebugEntryRequestor);
    }

    void parseDebugInfo(IDebugEntryRequestor iDebugEntryRequestor) {
        byte[] byArray = (byte[])this.dwarfSections.get(DWARF_DEBUG_INFO);
        if (byArray != null) {
            try {
                int n = 0;
                int n2 = 0;
                while (n2 < byArray.length) {
                    CompilationUnitHeader compilationUnitHeader = new CompilationUnitHeader();
                    compilationUnitHeader.length = n = this.read_4_bytes(byArray, n2);
                    compilationUnitHeader.version = this.read_2_bytes(byArray, n2 + 4);
                    compilationUnitHeader.abbreviationOffset = this.read_4_bytes(byArray, n2 + 6);
                    compilationUnitHeader.addressSize = byArray[n2 + 10];
                    System.out.println("Compilation Unit @ " + Long.toHexString(n2));
                    System.out.println(compilationUnitHeader);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n2 + 11, n);
                    Map map = this.parseDebugAbbreviation(compilationUnitHeader);
                    this.parseDebugInfoEntry(iDebugEntryRequestor, byteArrayInputStream, map, compilationUnitHeader);
                    System.out.println();
                    n2 += n + 4;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    Map parseDebugAbbreviation(CompilationUnitHeader compilationUnitHeader) throws IOException {
        int n = compilationUnitHeader.abbreviationOffset;
        Integer n2 = new Integer(n);
        HashMap<Long, AbbreviationEntry> hashMap = (HashMap<Long, AbbreviationEntry>)this.abbreviationMaps.get(n2);
        if (hashMap == null) {
            hashMap = new HashMap<Long, AbbreviationEntry>();
            this.abbreviationMaps.put(n2, hashMap);
            byte[] byArray = (byte[])this.dwarfSections.get(DWARF_DEBUG_ABBREV);
            if (byArray != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ((InputStream)byteArrayInputStream).skip(n);
                while (((InputStream)byteArrayInputStream).available() > 0) {
                    long l = this.read_unsigned_leb128(byteArrayInputStream);
                    if (l == 0L) break;
                    long l2 = this.read_unsigned_leb128(byteArrayInputStream);
                    byte by = (byte)((InputStream)byteArrayInputStream).read();
                    AbbreviationEntry abbreviationEntry = new AbbreviationEntry(l, l2, by);
                    long l3 = 0L;
                    long l4 = 0L;
                    do {
                        l3 = this.read_unsigned_leb128(byteArrayInputStream);
                        l4 = this.read_unsigned_leb128(byteArrayInputStream);
                        if (l3 == 0L) continue;
                        abbreviationEntry.attributes.add(new Attribute(l3, l4));
                    } while (l3 != 0L && l4 != 0L);
                    hashMap.put(new Long(l), abbreviationEntry);
                }
            }
        }
        return hashMap;
    }

    void parseDebugInfoEntry(IDebugEntryRequestor iDebugEntryRequestor, InputStream inputStream, Map map, CompilationUnitHeader compilationUnitHeader) throws IOException {
        while (inputStream.available() > 0) {
            long l = this.read_unsigned_leb128(inputStream);
            AbbreviationEntry abbreviationEntry = (AbbreviationEntry)map.get(new Long(l));
            if (abbreviationEntry == null) continue;
            int n = abbreviationEntry.attributes.size();
            ArrayList<AttributeValue> arrayList = new ArrayList<AttributeValue>(n);
            try {
                int n2 = 0;
                while (n2 < n) {
                    Attribute attribute = (Attribute)abbreviationEntry.attributes.get(n2);
                    Object object = this.readAttribute((int)attribute.form, inputStream, compilationUnitHeader);
                    arrayList.add(new AttributeValue(attribute, object));
                    ++n2;
                }
            }
            catch (IOException iOException) {}
            this.processDebugInfoEntry(iDebugEntryRequestor, abbreviationEntry, arrayList);
        }
    }

    Object readAttribute(int n, InputStream inputStream, CompilationUnitHeader compilationUnitHeader) throws IOException {
        Object object = null;
        switch (n) {
            case 1: 
            case 16: {
                object = this.readAddress(inputStream, compilationUnitHeader);
                break;
            }
            case 9: {
                int n2 = (int)this.read_unsigned_leb128(inputStream);
                byte[] byArray = new byte[n2];
                inputStream.read(byArray, 0, n2);
                object = byArray;
                break;
            }
            case 10: {
                int n3 = inputStream.read();
                byte[] byArray = new byte[n3];
                inputStream.read(byArray, 0, n3);
                object = byArray;
                break;
            }
            case 3: {
                short s = this.read_2_bytes(inputStream);
                byte[] byArray = new byte[s];
                inputStream.read(byArray, 0, s);
                object = byArray;
                break;
            }
            case 4: {
                int n4 = this.read_4_bytes(inputStream);
                byte[] byArray = new byte[n4];
                inputStream.read(byArray, 0, n4);
                object = byArray;
                break;
            }
            case 11: {
                object = new Byte((byte)inputStream.read());
                break;
            }
            case 5: {
                object = new Short(this.read_2_bytes(inputStream));
                break;
            }
            case 6: {
                object = new Integer(this.read_4_bytes(inputStream));
                break;
            }
            case 7: {
                object = new Long(this.read_8_bytes(inputStream));
                break;
            }
            case 13: {
                object = new Long(this.read_signed_leb128(inputStream));
                break;
            }
            case 15: {
                object = new Long(this.read_unsigned_leb128(inputStream));
                break;
            }
            case 8: {
                int n5;
                StringBuffer stringBuffer = new StringBuffer();
                while ((n5 = inputStream.read()) != -1) {
                    if (n5 == 0) break;
                    stringBuffer.append((char)n5);
                }
                object = stringBuffer.toString();
                break;
            }
            case 12: {
                object = new Byte((byte)inputStream.read());
                break;
            }
            case 14: {
                int n6 = this.read_4_bytes(inputStream);
                byte[] byArray = (byte[])this.dwarfSections.get(DWARF_DEBUG_STR);
                if (byArray == null) {
                    object = new String();
                    break;
                }
                if (n6 < 0 || n6 > byArray.length) {
                    object = new String();
                    break;
                }
                StringBuffer stringBuffer = new StringBuffer();
                while (n6 < byArray.length) {
                    byte by = byArray[n6];
                    if (by == 0) break;
                    stringBuffer.append((char)by);
                    ++n6;
                }
                object = stringBuffer.toString();
                break;
            }
            case 17: {
                object = new Byte((byte)inputStream.read());
                break;
            }
            case 18: {
                object = new Short(this.read_2_bytes(inputStream));
                break;
            }
            case 19: {
                object = new Integer(this.read_4_bytes(inputStream));
                break;
            }
            case 20: {
                object = new Long(this.read_8_bytes(inputStream));
                break;
            }
            case 21: {
                object = new Long(this.read_unsigned_leb128(inputStream));
                break;
            }
            case 22: {
                int n7 = (int)this.read_unsigned_leb128(inputStream);
                return this.readAttribute(n7, inputStream, compilationUnitHeader);
            }
        }
        return object;
    }

    void processDebugInfoEntry(IDebugEntryRequestor iDebugEntryRequestor, AbbreviationEntry abbreviationEntry, List list) {
        int n = list.size();
        int n2 = (int)abbreviationEntry.tag;
        System.out.println("Abbrev Number " + abbreviationEntry.code);
        int n3 = 0;
        while (n3 < n) {
            AttributeValue attributeValue = (AttributeValue)list.get(n3);
            System.out.println(attributeValue);
            switch (n2) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 11: {
                    break;
                }
                case 13: {
                    break;
                }
                case 15: {
                    break;
                }
                case 16: {
                    break;
                }
                case 17: {
                    this.processCompileUnit(iDebugEntryRequestor, list);
                    break;
                }
                case 19: {
                    break;
                }
                case 21: {
                    break;
                }
                case 22: {
                    break;
                }
                case 23: {
                    break;
                }
                case 24: {
                    break;
                }
                case 28: {
                    break;
                }
                case 31: {
                    break;
                }
                case 34: {
                    break;
                }
                case 36: {
                    break;
                }
                case 37: {
                    break;
                }
                case 38: {
                    break;
                }
                case 40: {
                    break;
                }
                case 41: {
                    break;
                }
                case 42: {
                    break;
                }
                case 46: {
                    this.processSubProgram(iDebugEntryRequestor, list);
                    break;
                }
                case 47: {
                    break;
                }
                case 48: {
                    break;
                }
                case 49: {
                    break;
                }
                case 50: {
                    break;
                }
                case 52: {
                    break;
                }
            }
            ++n3;
        }
    }

    Long readAddress(InputStream inputStream, CompilationUnitHeader compilationUnitHeader) throws IOException {
        long l = 0L;
        switch (compilationUnitHeader.addressSize) {
            case 2: {
                l = this.read_2_bytes(inputStream);
                break;
            }
            case 4: {
                l = this.read_4_bytes(inputStream);
                break;
            }
            case 8: {
                l = this.read_8_bytes(inputStream);
            }
        }
        return new Long(l);
    }

    void processSubProgram(IDebugEntryRequestor iDebugEntryRequestor, List list) {
        long l = 0L;
        long l2 = 0L;
        String string = "";
        boolean bl = false;
        int n = 0;
        while (n < list.size()) {
            AttributeValue attributeValue = (AttributeValue)list.get(n);
            try {
                int n2 = (int)attributeValue.attribute.name;
                switch (n2) {
                    case 17: {
                        l = ((Number)attributeValue.value).longValue();
                        break;
                    }
                    case 18: {
                        l2 = ((Number)attributeValue.value).longValue();
                        break;
                    }
                    case 3: {
                        string = (String)attributeValue.value;
                        break;
                    }
                    case 63: {
                        bl = ((Number)attributeValue.value).intValue() > 0;
                    }
                }
            }
            catch (ClassCastException classCastException) {}
            ++n;
        }
        iDebugEntryRequestor.enterFunction(string, new DebugUnknownType(""), bl, l);
        iDebugEntryRequestor.exitFunction(l2);
    }

    void processCompileUnit(IDebugEntryRequestor iDebugEntryRequestor, List list) {
        if (this.currentCU != null) {
            iDebugEntryRequestor.exitCompilationUnit(this.currentCU.highPC);
        }
        this.currentCU = new CompileUnit();
        int n = 0;
        while (n < list.size()) {
            AttributeValue attributeValue = (AttributeValue)list.get(n);
            try {
                int n2 = (int)attributeValue.attribute.name;
                switch (n2) {
                    case 17: {
                        this.currentCU.lowPC = ((Number)attributeValue.value).longValue();
                        break;
                    }
                    case 18: {
                        this.currentCU.highPC = ((Number)attributeValue.value).longValue();
                        break;
                    }
                    case 3: {
                        this.currentCU.name = (String)attributeValue.value;
                        break;
                    }
                    case 19: {
                        this.currentCU.language = ((Number)attributeValue.value).intValue();
                        break;
                    }
                    case 16: {
                        this.currentCU.stmtList = ((Number)attributeValue.value).intValue();
                        break;
                    }
                    case 67: {
                        this.currentCU.macroInfo = ((Number)attributeValue.value).intValue();
                        break;
                    }
                    case 27: {
                        this.currentCU.compDir = (String)attributeValue.value;
                        break;
                    }
                    case 37: {
                        this.currentCU.producer = (String)attributeValue.value;
                    }
                }
            }
            catch (ClassCastException classCastException) {}
            ++n;
        }
        iDebugEntryRequestor.enterCompilationUnit(this.currentCU.name, this.currentCU.lowPC);
    }

    public static void main(String[] stringArray) {
        try {
            DebugSymsRequestor debugSymsRequestor = new DebugSymsRequestor();
            Dwarf dwarf = new Dwarf(stringArray[0]);
            dwarf.parse(debugSymsRequestor);
            DebugSym[] debugSymArray = debugSymsRequestor.getEntries();
            int n = 0;
            while (n < debugSymArray.length) {
                DebugSym debugSym = debugSymArray[n];
                System.out.println(debugSym);
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    class CompilationUnitHeader {
        int length;
        short version;
        int abbreviationOffset;
        byte addressSize;

        CompilationUnitHeader() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Length: " + this.length).append("\n");
            stringBuffer.append("Version: " + this.version).append("\n");
            stringBuffer.append("Abbreviation: " + this.abbreviationOffset).append("\n");
            stringBuffer.append("Address size: " + this.addressSize).append("\n");
            return stringBuffer.toString();
        }
    }

    class AbbreviationEntry {
        long code;
        long tag;
        byte hasChildren;
        List attributes;

        AbbreviationEntry(long l, long l2, byte by) {
            this.code = l;
            this.tag = l2;
            this.hasChildren = by;
            this.attributes = new ArrayList();
        }
    }

    class Attribute {
        long name;
        long form;

        Attribute(long l, long l2) {
            this.name = l;
            this.form = l2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("name: " + Long.toHexString(this.name));
            stringBuffer.append(" value: " + Long.toHexString(this.form));
            return stringBuffer.toString();
        }
    }

    class AttributeValue {
        Attribute attribute;
        Object value;

        AttributeValue(Attribute attribute, Object object) {
            this.attribute = attribute;
            this.value = object;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.attribute.toString()).append(' ');
            if (this.value != null) {
                Class<?> clazz = this.value.getClass();
                if (clazz.isArray()) {
                    int n = Array.getLength(this.value);
                    stringBuffer.append(n).append(' ');
                    stringBuffer.append(clazz.getComponentType().toString());
                    stringBuffer.append(':');
                    int n2 = 0;
                    while (n2 < n) {
                        byte by = Array.getByte(this.value, n2);
                        stringBuffer.append(' ').append(Integer.toHexString(by));
                        ++n2;
                    }
                } else if (this.value instanceof Number) {
                    Number number = (Number)this.value;
                    stringBuffer.append(Long.toHexString(number.longValue()));
                } else if (this.value instanceof String) {
                    stringBuffer.append(this.value);
                } else {
                    stringBuffer.append(this.value);
                }
            }
            return stringBuffer.toString();
        }
    }

    class CompileUnit {
        long lowPC;
        long highPC;
        int stmtList;
        String name;
        int language;
        int macroInfo;
        String compDir;
        String producer;
        int identifierCase;

        CompileUnit() {
        }
    }
}

