/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;

public class CLineBreakpoint
extends CBreakpoint
implements ICLineBreakpoint {
    private static final String C_LINE_BREAKPOINT = "org.eclipse.cdt.debug.core.cLineBreakpointMarker";

    public CLineBreakpoint() {
    }

    public CLineBreakpoint(IResource iResource, Map map, boolean bl) throws DebugException {
        super(iResource, CLineBreakpoint.getMarkerType(), map, bl);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public static String getMarkerType() {
        return C_LINE_BREAKPOINT;
    }

    protected String getMarkerMessage() throws CoreException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("Line breakpoint:");
        String string = this.ensureMarker().getResource().getName();
        if (string != null && string.length() > 0) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        if ((n = this.getLineNumber()) > 0) {
            stringBuffer.append(" [");
            stringBuffer.append("line:");
            stringBuffer.append(' ');
            stringBuffer.append(n);
            stringBuffer.append(']');
        }
        stringBuffer.append(this.getConditionText());
        return stringBuffer.toString();
    }
}

