/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.core.parser.pst.ExtensibleSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class BasicSymbol
extends ExtensibleSymbol
implements ISymbol {
    private String _name;
    private TypeInfo _typeInfo;
    private int _depth;
    private boolean _isInvisible = false;
    private boolean _isTemplateMember = false;
    private ISymbol _instantiatedSymbol = null;

    public BasicSymbol(ParserSymbolTable parserSymbolTable, String string) {
        super(parserSymbolTable);
        this._name = string;
        this._typeInfo = new TypeInfo();
    }

    public BasicSymbol(ParserSymbolTable parserSymbolTable, String string, ISymbolASTExtension iSymbolASTExtension) {
        super(parserSymbolTable, iSymbolASTExtension);
        this._name = string;
        this._typeInfo = new TypeInfo();
    }

    public BasicSymbol(ParserSymbolTable parserSymbolTable, String string, TypeInfo.eType eType2) {
        super(parserSymbolTable);
        this._name = string;
        this._typeInfo = new TypeInfo(eType2, 0, null);
    }

    public ISymbol instantiate(ITemplateSymbol iTemplateSymbol, Map map) throws ParserSymbolTableException {
        if (!this.isTemplateMember() && !this.getContainingSymbol().isTemplateMember()) {
            return null;
        }
        ISymbol iSymbol = (ISymbol)this.clone();
        iSymbol.setTypeInfo(TemplateEngine.instantiateTypeInfo(iSymbol.getTypeInfo(), iTemplateSymbol, map));
        iSymbol.setInstantiatedSymbol(this);
        return iSymbol;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setContainingSymbol(IContainerSymbol iContainerSymbol) {
        super.setContainingSymbol(iContainerSymbol);
        this._depth = iContainerSymbol.getDepth() + 1;
    }

    public void setType(TypeInfo.eType eType2) {
        this.getTypeInfo().setType(eType2);
    }

    public TypeInfo.eType getType() {
        return this.getTypeInfo().getType();
    }

    public boolean isType(TypeInfo.eType eType2) {
        return this.getTypeInfo().isType(eType2, TypeInfo.t_undef);
    }

    public boolean isType(TypeInfo.eType eType2, TypeInfo.eType eType3) {
        return this.getTypeInfo().isType(eType2, eType3);
    }

    public ISymbol getTypeSymbol() {
        ISymbol iSymbol = this.getTypeInfo().getTypeSymbol();
        if (iSymbol != null && iSymbol.getTypeInfo().isForwardDeclaration() && iSymbol.getTypeSymbol() != null) {
            return iSymbol.getTypeSymbol();
        }
        return iSymbol;
    }

    public void setTypeSymbol(ISymbol iSymbol) {
        this.getTypeInfo().setTypeSymbol(iSymbol);
    }

    public TypeInfo getTypeInfo() {
        return this._typeInfo;
    }

    public void setTypeInfo(TypeInfo typeInfo) {
        this._typeInfo = typeInfo;
    }

    public boolean isForwardDeclaration() {
        return this.getTypeInfo().isForwardDeclaration();
    }

    public void setIsForwardDeclaration(boolean bl) {
        this.getTypeInfo().setIsForwardDeclaration(bl);
    }

    public int compareCVQualifiersTo(ISymbol iSymbol) {
        int n;
        int n2 = iSymbol.getTypeInfo().hasPtrOperators() ? iSymbol.getTypeInfo().getPtrOperators().size() : 0;
        int n3 = n = this.getTypeInfo().hasPtrOperators() ? this.getTypeInfo().getPtrOperators().size() : 0;
        if (n2 != n) {
            return n - n2;
        }
        if (n2 == 0) {
            return 0;
        }
        Iterator iterator = iSymbol.getTypeInfo().getPtrOperators().iterator();
        Iterator iterator2 = this.getTypeInfo().getPtrOperators().iterator();
        TypeInfo.PtrOp ptrOp = null;
        TypeInfo.PtrOp ptrOp2 = null;
        int n4 = n2;
        while (n4 > 0) {
            ptrOp = (TypeInfo.PtrOp)iterator.next();
            if (ptrOp.compareCVTo(ptrOp2 = (TypeInfo.PtrOp)iterator2.next()) != 0) {
                return -1;
            }
            --n4;
        }
        return 0;
    }

    public List getPtrOperators() {
        return this.getTypeInfo().getPtrOperators();
    }

    public void addPtrOperator(TypeInfo.PtrOp ptrOp) {
        this.getTypeInfo().addPtrOperator(ptrOp);
    }

    public int getDepth() {
        return this._depth;
    }

    public boolean isTemplateMember() {
        return this._isTemplateMember;
    }

    public void setIsTemplateMember(boolean bl) {
        this._isTemplateMember = bl;
    }

    public boolean isTemplateInstance() {
        return this._instantiatedSymbol != null;
    }

    public ISymbol getInstantiatedSymbol() {
        return this._instantiatedSymbol;
    }

    public void setInstantiatedSymbol(ISymbol iSymbol) {
        this._instantiatedSymbol = iSymbol;
    }

    public boolean getIsInvisible() {
        return this._isInvisible;
    }

    public void setIsInvisible(boolean bl) {
        this._isInvisible = bl;
    }
}

