/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.parser.Enum;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class TypeInfo {
    public static final int typeMask = 31;
    public static final int isAuto = 32;
    public static final int isRegister = 64;
    public static final int isStatic = 128;
    public static final int isExtern = 256;
    public static final int isMutable = 512;
    public static final int isInline = 1024;
    public static final int isVirtual = 2048;
    public static final int isExplicit = 4096;
    public static final int isTypedef = 8192;
    public static final int isFriend = 16384;
    public static final int isConst = 32768;
    public static final int isVolatile = 65536;
    public static final int isUnsigned = 131072;
    public static final int isShort = 262144;
    public static final int isLong = 524288;
    public static final int isForward = 0x100000;
    public static final int isComplex = 0x200000;
    public static final int isImaginary = 0x400000;
    public static final int isLongLong = 0x800000;
    public static final int isSigned = 0x1000000;
    public static final eType t_any = new eType(-1);
    public static final eType t_undef = new eType(0);
    public static final eType t_type = new eType(1);
    public static final eType t_namespace = new eType(2);
    public static final eType t_class = new eType(3);
    public static final eType t_struct = new eType(4);
    public static final eType t_union = new eType(5);
    public static final eType t_enumeration = new eType(6);
    public static final eType t_constructor = new eType(7);
    public static final eType t_function = new eType(8);
    public static final eType t__Bool = new eType(9);
    public static final eType t_bool = new eType(10);
    public static final eType t_char = new eType(11);
    public static final eType t_wchar_t = new eType(12);
    public static final eType t_int = new eType(13);
    public static final eType t_float = new eType(14);
    public static final eType t_double = new eType(15);
    public static final eType t_void = new eType(16);
    public static final eType t_enumerator = new eType(17);
    public static final eType t_block = new eType(18);
    public static final eType t_template = new eType(19);
    public static final eType t_asm = new eType(20);
    public static final eType t_linkage = new eType(21);
    public static final eType t_templateParameter = new eType(22);
    public static final eType t_typeName = new eType(23);
    private static final String[] _image = new String[]{"", "", "namespace", "class", "struct", "union", "enum", "", "", "bool", "char", "wchar_t", "int", "float", "double", "void", "", "", "template", "", ""};
    public static final int cvConst = 2;
    public static final int cvVolatile = 3;
    public static final int cvConstVolatile = 5;
    private int _typeInfo = 0;
    private eType _type = t_undef;
    private eType _templateParameterType = t_typeName;
    private ISymbol _typeDeclaration;
    private boolean _hasDefaultValue = false;
    private Object _defaultValue = null;
    private LinkedList _ptrOperators;
    private LinkedList _operatorExpressions;

    public TypeInfo() {
    }

    public TypeInfo(eType eType2, int n, ISymbol iSymbol) {
        this._typeInfo = n;
        this._type = eType2;
        this._typeDeclaration = iSymbol;
    }

    public TypeInfo(eType eType2, int n, ISymbol iSymbol, PtrOp ptrOp, boolean bl) {
        this._typeInfo = n;
        this._type = eType2;
        this._typeDeclaration = iSymbol;
        if (ptrOp != null) {
            this._ptrOperators = new LinkedList();
            this._ptrOperators.add(ptrOp);
        } else {
            this._ptrOperators = null;
        }
        this._hasDefaultValue = bl;
    }

    public TypeInfo(eType eType2, int n, ISymbol iSymbol, PtrOp ptrOp, Object object) {
        this._typeInfo = n;
        this._type = eType2;
        this._typeDeclaration = iSymbol;
        if (ptrOp != null) {
            this._ptrOperators = new LinkedList();
            this._ptrOperators.add(ptrOp);
        } else {
            this._ptrOperators = null;
        }
        this._hasDefaultValue = true;
        this.setDefault(object);
    }

    public TypeInfo(TypeInfo typeInfo) {
        this._typeInfo = typeInfo._typeInfo;
        this._type = typeInfo._type;
        this._typeDeclaration = typeInfo._typeDeclaration;
        this._ptrOperators = typeInfo._ptrOperators == null ? null : (LinkedList)typeInfo._ptrOperators.clone();
        this._hasDefaultValue = typeInfo._hasDefaultValue;
        this._defaultValue = typeInfo._defaultValue;
    }

    public void setBit(boolean bl, int n) {
        this._typeInfo = bl ? (this._typeInfo |= n) : (this._typeInfo &= ~n);
    }

    public boolean checkBit(int n) {
        return (this._typeInfo & n) != 0;
    }

    public void setType(eType eType2) {
        this._type = eType2;
    }

    public eType getType() {
        return this._type;
    }

    public boolean isType(eType eType2) {
        return this.isType(eType2, t_undef);
    }

    public int getTypeInfo() {
        return this._typeInfo;
    }

    public void setTypeInfo(int n) {
        this._typeInfo = n;
    }

    public eType getTemplateParameterType() {
        return this._templateParameterType;
    }

    public void setTemplateParameterType(eType eType2) {
        this._templateParameterType = eType2;
    }

    public boolean isType(eType eType2, eType eType3) {
        if (eType2 == t_any) {
            return true;
        }
        if (eType3 == t_undef) {
            return this.getType() == eType2;
        }
        return this.getType().compareTo(eType2) >= 0 && this.getType().compareTo(eType3) <= 0;
    }

    public ISymbol getTypeSymbol() {
        return this._typeDeclaration;
    }

    public void setTypeSymbol(ISymbol iSymbol) {
        this._typeDeclaration = iSymbol;
    }

    public boolean hasPtrOperators() {
        return this._ptrOperators != null && this._ptrOperators.size() > 0;
    }

    public List getPtrOperators() {
        if (this._ptrOperators == null) {
            this._ptrOperators = new LinkedList();
        }
        return this._ptrOperators;
    }

    public boolean hasSamePtrs(TypeInfo typeInfo) {
        int n = this.getPtrOperators().size();
        int n2 = typeInfo.getPtrOperators().size();
        Iterator iterator = this.getPtrOperators().iterator();
        Iterator iterator2 = typeInfo.getPtrOperators().iterator();
        PtrOp ptrOp = null;
        PtrOp ptrOp2 = null;
        if (n == n2) {
            if (n > 0) {
                int n3 = n;
                while (n3 > 0) {
                    ptrOp = (PtrOp)iterator.next();
                    ptrOp2 = (PtrOp)iterator2.next();
                    if (ptrOp.getType() != ptrOp2.getType()) {
                        return false;
                    }
                    --n3;
                }
            }
            return true;
        }
        return false;
    }

    public List getOperatorExpressions() {
        if (this._operatorExpressions == null) {
            this._operatorExpressions = new LinkedList();
        }
        return this._operatorExpressions;
    }

    public void applyOperatorExpressions(List list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = list.size();
        Iterator iterator = list.iterator();
        OperatorExpression operatorExpression = null;
        int n2 = n;
        while (n2 > 0) {
            Object object;
            operatorExpression = (OperatorExpression)iterator.next();
            if (operatorExpression == OperatorExpression.indirection || operatorExpression == OperatorExpression.subscript) {
                PtrOp ptrOp;
                if (this.hasPtrOperators() && ((ptrOp = (PtrOp)(object = this.getPtrOperators().listIterator(this.getPtrOperators().size())).previous()).getType() == PtrOp.t_pointer || ptrOp.getType() == PtrOp.t_array)) {
                    object.remove();
                }
            } else if (operatorExpression == OperatorExpression.addressof) {
                object = new PtrOp(PtrOp.t_pointer);
                this.addPtrOperator((PtrOp)object);
            }
            --n2;
        }
    }

    public void addPtrOperator(PtrOp ptrOp) {
        if (this._ptrOperators == null) {
            this._ptrOperators = new LinkedList();
        }
        if (ptrOp != null) {
            this._ptrOperators.add(ptrOp);
        }
    }

    public void addPtrOperator(List list) {
        if (this._ptrOperators == null) {
            this._ptrOperators = new LinkedList();
        }
        if (list != null) {
            this._ptrOperators.addAll(list);
        }
    }

    public void addOperatorExpression(OperatorExpression operatorExpression) {
        if (this._operatorExpressions == null) {
            this._operatorExpressions = new LinkedList();
        }
        this._operatorExpressions.add(operatorExpression);
    }

    public boolean getHasDefault() {
        return this._hasDefaultValue;
    }

    public void setHasDefault(boolean bl) {
        this._hasDefaultValue = bl;
    }

    public void setDefault(Object object) {
        this._defaultValue = object;
    }

    public Object getDefault() {
        return this._defaultValue;
    }

    public boolean isForwardDeclaration() {
        return this.checkBit(0x100000);
    }

    public void setIsForwardDeclaration(boolean bl) {
        this.setBit(bl, 0x100000);
    }

    public boolean canHold(TypeInfo typeInfo) {
        if (this.getType().compareTo(typeInfo.getType()) > 0) {
            return true;
        }
        int n = 0x8C0000;
        return (this.getTypeInfo() & n) >= (typeInfo.getTypeInfo() & n);
    }

    public boolean equals(Object object) {
        int n;
        if (object == null || !(object instanceof TypeInfo)) {
            return false;
        }
        TypeInfo typeInfo = (TypeInfo)object;
        boolean bl = this._typeInfo == typeInfo._typeInfo;
        bl &= this._type == typeInfo._type;
        if (this._typeDeclaration != null && typeInfo._typeDeclaration != null && this._typeDeclaration.isType(t__Bool, t_void) && typeInfo._typeDeclaration.isType(t__Bool, t_void)) {
            bl &= this._typeDeclaration.getType() == typeInfo._typeDeclaration.getType();
        } else if (this._typeDeclaration != null && typeInfo._typeDeclaration != null && this._typeDeclaration.isType(t_function) && typeInfo._typeDeclaration.isType(t_function)) {
            IParameterizedSymbol iParameterizedSymbol = (IParameterizedSymbol)this._typeDeclaration;
            IParameterizedSymbol iParameterizedSymbol2 = (IParameterizedSymbol)typeInfo._typeDeclaration;
            bl &= iParameterizedSymbol.hasSameParameters(iParameterizedSymbol2);
            bl &= iParameterizedSymbol.getReturnType().getTypeInfo().equals(iParameterizedSymbol2.getReturnType().getTypeInfo());
        } else {
            bl &= this._typeDeclaration == typeInfo._typeDeclaration;
        }
        int n2 = this._ptrOperators == null ? 0 : this._ptrOperators.size();
        int n3 = n = typeInfo._ptrOperators == null ? 0 : typeInfo._ptrOperators.size();
        if (n2 == n) {
            if (n2 != 0) {
                Iterator iterator = this._ptrOperators.iterator();
                Iterator iterator2 = typeInfo._ptrOperators.iterator();
                PtrOp ptrOp = null;
                PtrOp ptrOp2 = null;
                int n4 = n2;
                while (n4 > 0) {
                    ptrOp = (PtrOp)iterator.next();
                    if (!ptrOp.equals(ptrOp2 = (PtrOp)iterator2.next())) {
                        return false;
                    }
                    --n4;
                }
            }
        } else {
            return false;
        }
        return bl;
    }

    public String toString() {
        if (this.isType(t_type)) {
            return this._typeDeclaration.getName();
        }
        return _image[this.getType().toInt()];
    }

    public static class eType
    implements Comparable {
        private int _val;

        protected eType(int n) {
            this._val = n;
        }

        public int compareTo(Object object) {
            eType eType2 = (eType)object;
            return this._val - eType2._val;
        }

        public int toInt() {
            return this._val;
        }
    }

    public static class OperatorExpression
    extends Enum {
        public static final OperatorExpression indirection = new OperatorExpression(1);
        public static final OperatorExpression addressof = new OperatorExpression(0);
        public static final OperatorExpression subscript = new OperatorExpression(2);

        protected OperatorExpression(int n) {
            super(n);
        }
    }

    public static class PtrOp {
        public static final eType t_undef = new eType(0);
        public static final eType t_pointer = new eType(1);
        public static final eType t_reference = new eType(2);
        public static final eType t_array = new eType(3);
        public static final eType t_memberPointer = new eType(4);
        private eType type = t_undef;
        private boolean isConst = false;
        private boolean isVolatile = false;
        private ISymbol memberOf = null;

        public PtrOp(eType eType2) {
            this.type = eType2;
        }

        public PtrOp(eType eType2, boolean bl, boolean bl2) {
            this.type = eType2;
            this.isConst = bl;
            this.isVolatile = bl2;
        }

        public PtrOp(ISymbol iSymbol, boolean bl, boolean bl2) {
            this.type = t_memberPointer;
            this.isConst = bl;
            this.isVolatile = bl2;
            this.memberOf = iSymbol;
        }

        public PtrOp() {
        }

        public eType getType() {
            return this.type;
        }

        public void setType(eType eType2) {
            this.type = eType2;
        }

        public boolean isConst() {
            return this.isConst;
        }

        public boolean isVolatile() {
            return this.isVolatile;
        }

        public void setConst(boolean bl) {
            this.isConst = bl;
        }

        public void setVolatile(boolean bl) {
            this.isVolatile = bl;
        }

        public ISymbol getMemberOf() {
            return this.memberOf;
        }

        public void setMemberOf(ISymbol iSymbol) {
            this.memberOf = iSymbol;
        }

        public int compareCVTo(PtrOp ptrOp) {
            int n = (this.isConst() ? 1 : 0) + (this.isVolatile() ? 1 : 0);
            int n2 = (ptrOp.isConst() ? 1 : 0) + (ptrOp.isVolatile() ? 1 : 0);
            return n - n2;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof PtrOp)) {
                return false;
            }
            PtrOp ptrOp = (PtrOp)object;
            return this.isConst() == ptrOp.isConst() && this.isVolatile() == ptrOp.isVolatile() && this.getType() == ptrOp.getType();
        }
    }
}

