/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIEnvironmentCD;
import org.eclipse.cdt.debug.mi.core.command.MIExecArguments;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetEnvironment;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;

public class RuntimeOptions
implements ICDIRuntimeOptions {
    Session session;

    public RuntimeOptions(Session session) {
        this.session = session;
    }

    public void setArguments(String[] stringArray) throws CDIException {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIExecArguments mIExecArguments = commandFactory.createMIExecArguments(stringArray);
        try {
            mISession.postCommand(mIExecArguments);
            MIInfo mIInfo = mIExecArguments.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException("Unable to set arguments: target is not responding");
            }
        }
        catch (MIException mIException) {
            throw new CDIException("Unable to set arguments: " + mIException.getMessage());
        }
    }

    public void setEnvironment(Properties properties) throws CDIException {
        if (properties == null) {
            return;
        }
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        Iterator iterator = ((Hashtable)properties).keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = properties.getProperty(string);
            String[] stringArray = null;
            stringArray = string2 == null || string2.length() == 0 ? new String[]{string} : new String[]{string, string2};
            MIGDBSetEnvironment mIGDBSetEnvironment = commandFactory.createMIGDBSetEnvironment(stringArray);
            try {
                mISession.postCommand(mIGDBSetEnvironment);
                MIInfo mIInfo = mIGDBSetEnvironment.getMIInfo();
                if (mIInfo != null) continue;
                throw new CDIException("Unable to set environment: target is not responding");
            }
            catch (MIException mIException) {
                throw new CDIException("Unable to set environment: " + mIException.getMessage());
            }
        }
    }

    public void setWorkingDirectory(String string) throws CDIException {
        if (string == null || string.length() == 0) {
            return;
        }
        MISession mISession = this.session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIEnvironmentCD mIEnvironmentCD = commandFactory.createMIEnvironmentCD(string);
        try {
            mISession.postCommand(mIEnvironmentCD);
            MIInfo mIInfo = mIEnvironmentCD.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException("Unable to set working directory: target is not responding");
            }
        }
        catch (MIException mIException) {
            throw new CDIException("Unable to set working directory: " + mIException.getMessage());
        }
    }
}

