/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIVariableManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgument;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.ArgumentObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIPType;
import org.eclipse.cdt.debug.mi.core.command.MIStackListArguments;
import org.eclipse.cdt.debug.mi.core.command.MIStackListLocals;
import org.eclipse.cdt.debug.mi.core.command.MIVarDelete;
import org.eclipse.cdt.debug.mi.core.command.MIVarUpdate;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarDeletedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIArg;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIPTypeInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListArgumentsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListLocalsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarUpdateInfo;

public class VariableManager
extends SessionObject
implements ICDIVariableManager {
    int MAX_STACK_DEPTH = 200;
    List variableList;
    boolean autoupdate = true;
    MIVarChange[] noChanges = new MIVarChange[0];

    public VariableManager(Session session) {
        super(session);
        this.variableList = Collections.synchronizedList(new ArrayList());
    }

    public Variable getVariable(String string) {
        Variable[] variableArray = this.getVariables();
        int n = 0;
        while (n < variableArray.length) {
            if (variableArray[n].getMIVar().getVarName().equals(string)) {
                return variableArray[n];
            }
            Variable variable = variableArray[n].getChild(string);
            if (variable != null) {
                return variable;
            }
            ++n;
        }
        return null;
    }

    Variable findVariable(VariableObject variableObject) throws CDIException {
        ICDIStackFrame iCDIStackFrame = variableObject.getStackFrame();
        String string = variableObject.getName();
        int n = variableObject.getPosition();
        int n2 = variableObject.getStackDepth();
        Variable[] variableArray = this.getVariables();
        int n3 = 0;
        while (n3 < variableArray.length) {
            if (variableArray[n3].getName().equals(string) && variableArray[n3].getCastingArrayStart() == variableObject.getCastingArrayStart() && variableArray[n3].getCastingArrayEnd() == variableObject.getCastingArrayEnd() && (variableArray[n3].getCastingType() == null && variableObject.getCastingType() == null || variableArray[n3].getCastingType() != null && variableObject.getCastingType() != null && variableArray[n3].getCastingType().equals(variableObject.getCastingType()))) {
                ICDIStackFrame iCDIStackFrame2 = variableArray[n3].getStackFrame();
                if (iCDIStackFrame == null && iCDIStackFrame2 == null) {
                    return variableArray[n3];
                }
                if (iCDIStackFrame2 != null && iCDIStackFrame != null && iCDIStackFrame2.equals(iCDIStackFrame) && variableArray[n3].getPosition() == n && variableArray[n3].getStackDepth() == n2) {
                    return variableArray[n3];
                }
            }
            ++n3;
        }
        return null;
    }

    Variable[] getVariables() {
        return this.variableList.toArray(new Variable[0]);
    }

    public void checkType(String string) throws CDIException {
        block4: {
            if (string != null && string.length() > 0) {
                try {
                    MISession mISession = ((Session)this.getSession()).getMISession();
                    CommandFactory commandFactory = mISession.getCommandFactory();
                    MIPType mIPType = commandFactory.createMIPType(string);
                    mISession.postCommand(mIPType);
                    MIPTypeInfo mIPTypeInfo = mIPType.getMIPtypeInfo();
                    if (mIPTypeInfo == null) {
                        throw new CDIException("No answer");
                    }
                    break block4;
                }
                catch (MIException mIException) {
                    throw new MI2CDIException(mIException);
                }
            }
            throw new CDIException("Unknown type");
        }
    }

    void removeMIVar(MIVar mIVar) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIVarDelete mIVarDelete = commandFactory.createMIVarDelete(mIVar.getVarName());
        try {
            mISession.postCommand(mIVarDelete);
            mIVarDelete.getMIInfo();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public void removeVariable(String string) throws CDIException {
        Variable[] variableArray = this.getVariables();
        int n = 0;
        while (n < variableArray.length) {
            if (variableArray[n].getMIVar().getVarName().equals(string)) {
                this.variableList.remove(variableArray[n]);
                this.removeMIVar(variableArray[n].getMIVar());
            }
            ++n;
        }
    }

    /*
     * Exception decompiling
     */
    public ICDIArgument createArgument(ICDIArgumentObject var1_1) throws CDIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 242->245)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIArgumentObject[] getArgumentObjects(ICDIStackFrame iCDIStackFrame) throws CDIException {
        ArrayList<ArgumentObject> arrayList = new ArrayList<ArgumentObject>();
        Session session = (Session)this.getSession();
        ICDITarget iCDITarget = session.getCurrentTarget();
        ICDIThread iCDIThread = iCDITarget.getCurrentThread();
        ICDIStackFrame iCDIStackFrame2 = iCDIThread.getCurrentStackFrame();
        iCDIStackFrame.getThread().setCurrentStackFrame(iCDIStackFrame, false);
        try {
            try {
                MISession mISession = session.getMISession();
                CommandFactory commandFactory = mISession.getCommandFactory();
                int n = iCDIStackFrame.getThread().getStackFrameCount();
                int n2 = iCDIStackFrame.getLevel();
                int n3 = n - n2;
                MIStackListArguments mIStackListArguments = commandFactory.createMIStackListArguments(false, n3, n3);
                MIArg[] mIArgArray = null;
                mISession.postCommand(mIStackListArguments);
                MIStackListArgumentsInfo mIStackListArgumentsInfo = mIStackListArguments.getMIStackListArgumentsInfo();
                if (mIStackListArgumentsInfo == null) {
                    throw new CDIException("No answer");
                }
                MIFrame[] mIFrameArray = mIStackListArgumentsInfo.getMIFrames();
                if (mIFrameArray != null && mIFrameArray.length == 1) {
                    mIArgArray = mIFrameArray[0].getArgs();
                }
                if (mIArgArray != null) {
                    ICDITarget iCDITarget2 = iCDIStackFrame.getThread().getTarget();
                    int n4 = 0;
                    while (n4 < mIArgArray.length) {
                        ArgumentObject argumentObject = new ArgumentObject(iCDITarget2, mIArgArray[n4].getName(), iCDIStackFrame, mIArgArray.length - n4, n2);
                        arrayList.add(argumentObject);
                        ++n4;
                    }
                }
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            iCDIThread.setCurrentStackFrame(iCDIStackFrame2);
            throw throwable;
        }
        {
            Object var19_22 = null;
        }
        iCDIThread.setCurrentStackFrame(iCDIStackFrame2);
        return arrayList.toArray(new ICDIArgumentObject[0]);
    }

    public ICDIVariableObject getGlobalVariableObject(String string, String string2, String string3) throws CDIException {
        if (string == null) {
            string = new String();
        }
        if (string2 == null) {
            string2 = new String();
        }
        if (string3 == null) {
            string3 = new String();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() > 0) {
            stringBuffer.append('\'').append(string).append('\'').append("::");
        }
        if (string2.length() > 0) {
            stringBuffer.append(string2).append("::");
        }
        stringBuffer.append(string3);
        ICDITarget iCDITarget = this.getSession().getCurrentTarget();
        return new VariableObject(iCDITarget, stringBuffer.toString(), null, 0, 0);
    }

    public ICDIVariableObject getVariableObjectAsArray(ICDIVariableObject iCDIVariableObject, int n, int n2) throws CDIException {
        VariableObject variableObject = null;
        if (iCDIVariableObject instanceof VariableObject) {
            variableObject = (VariableObject)iCDIVariableObject;
        }
        if (variableObject != null) {
            VariableObject variableObject2 = new VariableObject(variableObject.getTarget(), variableObject.getName(), variableObject.getFullName(), variableObject.getStackFrame(), variableObject.getPosition(), variableObject.getStackDepth());
            variableObject2.setCastingArrayStart(variableObject.getCastingArrayStart() + n);
            variableObject2.setCastingArrayEnd(n2);
            return variableObject2;
        }
        throw new CDIException("Unknown variable object");
    }

    public ICDIVariableObject getVariableObjectAsType(ICDIVariableObject iCDIVariableObject, String string) throws CDIException {
        VariableObject variableObject = null;
        if (iCDIVariableObject instanceof VariableObject) {
            variableObject = (VariableObject)iCDIVariableObject;
        }
        if (variableObject != null) {
            this.checkType(string);
            VariableObject variableObject2 = new VariableObject(variableObject.getTarget(), variableObject.getName(), variableObject.getFullName(), variableObject.getStackFrame(), variableObject.getPosition(), variableObject.getStackDepth());
            String string2 = variableObject.getCastingType();
            if (string2 != null && string2.length() > 0) {
                string = "(" + string + ")" + "(" + string2 + " )";
            }
            variableObject2.setCastingType(string);
            return variableObject2;
        }
        throw new CDIException("Unknown variable object");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIVariableObject[] getLocalVariableObjects(ICDIStackFrame iCDIStackFrame) throws CDIException {
        ArrayList<VariableObject> arrayList = new ArrayList<VariableObject>();
        Session session = (Session)this.getSession();
        ICDITarget iCDITarget = session.getCurrentTarget();
        ICDIThread iCDIThread = iCDITarget.getCurrentThread();
        ICDIStackFrame iCDIStackFrame2 = iCDIThread.getCurrentStackFrame();
        iCDIStackFrame.getThread().setCurrentStackFrame(iCDIStackFrame, false);
        try {
            try {
                MISession mISession = session.getMISession();
                CommandFactory commandFactory = mISession.getCommandFactory();
                int n = iCDIStackFrame.getLevel();
                MIArg[] mIArgArray = null;
                MIStackListLocals mIStackListLocals = commandFactory.createMIStackListLocals(false);
                mISession.postCommand(mIStackListLocals);
                MIStackListLocalsInfo mIStackListLocalsInfo = mIStackListLocals.getMIStackListLocalsInfo();
                if (mIStackListLocalsInfo == null) {
                    throw new CDIException("No answer");
                }
                mIArgArray = mIStackListLocalsInfo.getLocals();
                if (mIArgArray != null) {
                    ICDITarget iCDITarget2 = iCDIStackFrame.getThread().getTarget();
                    int n2 = 0;
                    while (n2 < mIArgArray.length) {
                        VariableObject variableObject = new VariableObject(iCDITarget2, mIArgArray[n2].getName(), iCDIStackFrame, mIArgArray.length - n2, n);
                        arrayList.add(variableObject);
                        ++n2;
                    }
                }
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            iCDIThread.setCurrentStackFrame(iCDIStackFrame2, false);
            throw throwable;
        }
        {
            Object var16_19 = null;
        }
        iCDIThread.setCurrentStackFrame(iCDIStackFrame2, false);
        return arrayList.toArray(new ICDIVariableObject[0]);
    }

    public ICDIVariableObject[] getVariableObjects(ICDIStackFrame iCDIStackFrame) throws CDIException {
        ICDIVariableObject[] iCDIVariableObjectArray = this.getLocalVariableObjects(iCDIStackFrame);
        ICDIArgumentObject[] iCDIArgumentObjectArray = this.getArgumentObjects(iCDIStackFrame);
        ICDIVariableObject[] iCDIVariableObjectArray2 = new ICDIVariableObject[iCDIVariableObjectArray.length + iCDIArgumentObjectArray.length];
        System.arraycopy(iCDIVariableObjectArray, 0, iCDIVariableObjectArray2, 0, iCDIVariableObjectArray.length);
        System.arraycopy(iCDIArgumentObjectArray, 0, iCDIVariableObjectArray2, iCDIVariableObjectArray.length, iCDIArgumentObjectArray.length);
        return iCDIVariableObjectArray2;
    }

    /*
     * Exception decompiling
     */
    public ICDIVariable createVariable(ICDIVariableObject var1_1) throws CDIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 219->222)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void destroyVariable(ICDIVariable iCDIVariable) throws CDIException {
        if (iCDIVariable instanceof Variable) {
            Variable variable = (Variable)iCDIVariable;
            MIVarDeletedEvent mIVarDeletedEvent = new MIVarDeletedEvent(variable.getMIVar().getVarName());
            Session session = (Session)this.getSession();
            MISession mISession = session.getMISession();
            mISession.fireEvent(mIVarDeletedEvent);
        }
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean bl) {
        this.autoupdate = bl;
    }

    public void update() throws CDIException {
        ICDIThread iCDIThread;
        int n = 0;
        int n2 = 0;
        ArrayList<MIEvent> arrayList = new ArrayList<MIEvent>();
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        Variable[] variableArray = this.getVariables();
        ICDITarget iCDITarget = session.getCurrentTarget();
        ICDIStackFrame[] iCDIStackFrameArray = null;
        ICDIStackFrame iCDIStackFrame = null;
        if (iCDITarget != null && (iCDIThread = iCDITarget.getCurrentThread()) != null) {
            iCDIStackFrame = iCDIThread.getCurrentStackFrame();
            if (iCDIStackFrame != null) {
                n = iCDIStackFrame.getLevel();
            }
            if (n > 0) {
                --n;
            }
            if ((n2 = n - this.MAX_STACK_DEPTH) < 0) {
                n2 = 0;
            }
            iCDIStackFrameArray = iCDIThread.getStackFrames(n2, n);
        }
        int n3 = 0;
        while (n3 < variableArray.length) {
            Variable variable = variableArray[n3];
            if (this.isVariableNeedsToBeUpdate(variable, iCDIStackFrame, iCDIStackFrameArray, n2)) {
                String string = variable.getMIVar().getVarName();
                MIVarChange[] mIVarChangeArray = this.noChanges;
                MIVarUpdate mIVarUpdate = commandFactory.createMIVarUpdate(string);
                try {
                    mISession.postCommand(mIVarUpdate);
                    MIVarUpdateInfo mIVarUpdateInfo = mIVarUpdate.getMIVarUpdateInfo();
                    if (mIVarUpdateInfo == null) {
                        throw new CDIException("No answer");
                    }
                    mIVarChangeArray = mIVarUpdateInfo.getMIVarChanges();
                }
                catch (MIException mIException) {
                    arrayList.add(new MIVarDeletedEvent(string));
                }
                int n4 = 0;
                while (n4 < mIVarChangeArray.length) {
                    String string2 = mIVarChangeArray[n4].getVarName();
                    if (mIVarChangeArray[n4].isInScope()) {
                        arrayList.add(new MIVarChangedEvent(string2));
                    } else {
                        arrayList.add(new MIVarDeletedEvent(string2));
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        MIEvent[] mIEventArray = arrayList.toArray(new MIEvent[0]);
        mISession.fireEvents(mIEventArray);
    }

    boolean isVariableNeedsToBeUpdate(Variable variable, ICDIStackFrame iCDIStackFrame, ICDIStackFrame[] iCDIStackFrameArray, int n) throws CDIException {
        ICDIStackFrame iCDIStackFrame2 = variable.getStackFrame();
        boolean bl = false;
        if (iCDIStackFrame == null || iCDIStackFrameArray == null) {
            return false;
        }
        if (iCDIStackFrame2 == null) {
            return true;
        }
        if (iCDIStackFrame2.equals(iCDIStackFrame)) {
            return true;
        }
        if (iCDIStackFrame2.getLevel() >= n) {
            int n2 = 0;
            while (n2 < iCDIStackFrameArray.length) {
                if (iCDIStackFrame2.equals(iCDIStackFrameArray[n2])) {
                    bl = true;
                }
                ++n2;
            }
        } else {
            bl = true;
        }
        return !bl;
    }
}

